/*
 *  gain.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <complex.h>
#include <signal.h>
#include "ObjProDSP/portable.h"
#include "ObjProComGui/usercom.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProArithGen/arthfnc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProArithGen/artherr.h"
#include "ObjProDSPint/netlnk.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/gain.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * GainNodeList = 0 ;
static InteractiveEntity * IntEntGain ;
void GainNodesInit();
Gain::Gain (const char * Name, double Scale):
	ProcessNodeStr(Name, 1, 1, new StreamStr(StreamNotSet), 
	new StreamStr(StreamNotSet), 0, 1, 1, 0, 0, TimingTypeLinear)
,
	Scale_1(Scale)
{
	if (!GainNodeList) GainNodesInit() ;
	GainNodeList->Append(MakeDeclaredEntity(this, IntEntGain)) ;
	InitArithType(TheArithType);
	NewMenuItem("Gain",GetName());
#line 33 "../gain.usr"
 
	NumberOfOverflows = 0;
#line 47 "../gain.C"
} // end constructor

Gain::~Gain()
{
	TheMenuServer->DeleteMenuItem("Gain",GetName());
	GainNodeList->Delete(GetName()) ;
} // end destructor

int Gain::CheckSafeDelete()
{
	int Safe_Check_Return = UserEntity::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

Gain * GainDef;

ErrCode Gain::DoNode(int32 k)
{
#line 46 "../gain.usr"
 
	int32 ElementSize = GetInLink(0)->GetElementSize();
	int32 SaveOverflows = NumberOfOverflows ;
	for (int32 i = 0 ; i < k ; i++ ) 
		for (int32 l = 0 ; l < ElementSize; l++) {
			OverflowCheck Out = (OverflowCheck)
				(GetScale() * (double) ReadWord()) ;
			NumberOfOverflows += ArithCheckOverflow(Out);
			WriteWord((MachWordCast) Out);
		}
	
	if (NumberOfOverflows > SaveOverflows) ReportOverflows(
		NumberOfOverflows, SaveOverflows,GetName());
	return OK ;
#line 82 "../gain.C"
} // end kernel code

static UserEntity * MakeGain(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int Gain::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntGain->CppList(Out,Cmd,this);
}

void Gain::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeGain(Out,EntityReqDescribeFull,*IntEntGain,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("Scale");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetScale()));
		Out.NextFillOut(")");
		Out.NextFillOut("specifies the ratio of input amplitude to");
		Out.NextFillOut("output amplitude. Integer overflows are prevented");
		Out.NextFillOut("by clipping. The first");
		Out.NextFillOut("time clipping occurs a help message is generated. A new help");
		Out.NextFillOut("message is generated after every 400 clippings.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntGain->GetOneParameter("Scale")->
			FloatP->CurrentValue = Scale_1;
		break;
	}
} // end  list entity switch

static ValueType * SetScale(OutTokens&,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
	break ;
case EntityReqDescribeFull:
	break ;
case EntityReqCall:
		{		// Call procedure
				double Scale =
			Param->GetFloatParameterValue("Scale");
		((Gain *) This)->SetScale(Scale);
		return 0 ;
	}
	}
	return 0;
}

void GainNodesInit()
{
	if (GainNodeList)  return ;

	static StringParam GainNameParam =
		{"Gain", MakeNewEntityName, 0, LegalEntityName};
	static FloatParam GainScaleParam = {
		 1.0, 0, 0, -1e+100, 0, 1e+100};

	static OneParameter GainParArray[] = {
		{"Name", 0, "node name", 0, 0, &GainNameParam},
		{"Scale", 0, 
			"ratio of input amplitude to output amplitude",
			0, &GainScaleParam},
		{0}
	};

	static OneParameter SetScaleGainList[] = {
		{"Scale", 0, "ratio of input amplitude to output amplitude",
			 0, &GainScaleParam},
			{0}
	};
	UserParameters * SetScaleMemberParam = new UserParameters
		(SetScaleGainList);

	Procedure * SetMemberProcScale = new Procedure("SetScale", SetScale,
		 SetScaleMemberParam, "void");
static ValueType * GainMembers[2] ;
	int ii = 0 ;
	GainMembers[ii++] = new ValueType(DecProcedure, SetMemberProcScale) ;
	GainMembers[ii++] = 0 ;
	GainNodeList = new EntityList;
	IntEntGain = new InteractiveEntity("Gain", GainNodeList,
		MakeGain, InteractiveNode, "gain.h",
		GainMembers, "ProcessNodeStr");
	IntEntGain->SetParameters(new UserParameters(GainParArray));
	TheNodes->Append(IntEntGain);
} // end initalization

static UserEntity * MakeGain(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("Gain");
		Out.NextFillOut("copies its input to its output after applying a liner");
		Out.NextFillOut("scale factor (");
		Out.NextFillOutConcat("Scale");
		Out.NextFillOutConcat(") to each input sample element.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		double Scale =
			IntNode.GetFloatParameterValue("Scale");
		return new Gain(Name, Scale);

	}
	}
	return 0;
}

static InitObj LocalInit(GainNodesInit, "Gain", "ProcessNodeStr");

