/*
 *  tarnod4.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <limits.h>
#include <libc.h>
#include "tarnod.h"
#include "netlnk.h"
#include "cgidbg.h"
#include "dskchnhd.h"
#include "cgidbg.h"
#include "exec.h"

extern const char * LastNodeInDspNetwork ;
extern int InNodeInDspNetwork  ;


#define DO_NODE(Count,Return) { \
		if (ExecuteState::show()) \
			TheLog << Count << ":" << GetName() << "\n" ; \
		LastNodeInDspNetwork = GetName(); \
		InNodeInDspNetwork = 1 ; \
		Return = DoNode(Count) ; \
		InNodeInDspNetwork = 0 ; \
		/* TheLog << " Af\n" ; */ \
	}

ErrCode TargetNode::ExecuteDynamicNode(int32& Count)
{
	ErrCode Return = OK ;
	switch (ExecuteType) {
case NodeExecuteFixedBound:
		Count = GetDynamicCount();
		if (Delay > History) {
			History += Count ;
			if (History > Delay) History = Delay ;
		}
/*
 *	  	TheLog << "Executing dyn node " << GetName() << "(" << Count
 *			<< ")\n" ;
 */
		// TestAlloc("Before");
		if (!Count) return OK;
		DO_NODE(Count,Return);
		// TestAlloc("After");
		return Return ;
case NodeExecuteSpaceBound:
		break ;
case NodeExecuteFixedIgnoreSpace:
		break ;
	}
}

ErrCode TargetNode::ExecuteNode(int32& Count)
{
	switch (ExecuteType) {
case NodeExecuteFixedBound:
		if (!ExecutionSequence) {
			ExecutionIndex++ ;
			return OK ;
		}
#ifdef DEBUG
		// TheLog << "ExecututionIndex = " << ExecutionIndex << "\n" ;
		if (ExecutionSequence[ExecutionIndex] < 0) ExecutionIndex = 0 ;
		// TheLog << "ExecututionIndex = " << ExecutionIndex << "\n" ;
		if (TheState->GetGlobalExecutionIndex() !=
			ExecutionIndex ||
			TheState->GetGlobalSequenceIndex()
			!= SequenceIndex)
			    DbgError("TargetNode::ExecuteNode","bad indicies");
		ExecutionIndex++;
#endif
		Count = ExecutionSequence[
			TheState->GetGlobalExecutionIndex()] ;
/*
 *		TheLog << "Executing node " << GetName() << "(" << Count
 *			<< ")\n" ;
 */
		if (!Count) return OK;
		ErrCode Return = OK ;
		DO_NODE(Count,Return);
		return Return ;
case NodeExecuteSpaceBound:
		break ;
case NodeExecuteFixedIgnoreSpace:
		break ;
	}
}

