/*
 *  const.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef CONST_DOT_H
#define CONST_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class ConstantData: public TargetNode {
	int32  Value_1;
public:
	ConstantData (const char * Name, int32 Value,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~ConstantData();
	int32 GetValue() const {return Value_1;}
	virtual ErrCode DoNode(int32);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetValue(int32  Value) { Value_1 = Value; parameter_changed(); }
};

extern ConstantData * ConstantDataDef;


#endif /* #ifdef CONST_DOT_H */
