/*
 *  demux.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef DEMUX_DOT_H
#define DEMUX_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procnode.h"

class Demux: public ProcessNode {
	int16  Channels_1;
	int32  InputSampleSize_2;
	int32  InputElementSize_3;
	int32  OutputElementSize_4;
public:
	Demux (const char * Name, int16 Channels, int32 InputSampleSize, 
		int32 InputElementSize, int32 OutputElementSize);
	virtual ~Demux();
	int16 GetChannels() const {return Channels_1;}
	int32 GetInputSampleSize() const {return InputSampleSize_2;}
	int32 GetInputElementSize() const {return InputElementSize_3;}
	int32 GetOutputElementSize() const {return OutputElementSize_4;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
};

extern Demux * DemuxDef;


#endif /* #ifdef DEMUX_DOT_H */
