#if 0
drealmBBS - Bulletin Board System for Linux
Copyright (C) 1994, 1995  Inge Cubitt and Peter Jones

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The GNU General Public License should be in a file called COPYING.
#endif

#if defined(SVR42)
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/select.h>
int select(int nfds, fd_set *r, fd_set *w, fd_set *e, struct timeval *tv);

#include "drealm_sig.h"
#include "drealm_select.h"

/* ARGSUSED0 */
static void alrm_handler(int sig) {
#if defined(DEBUG_ISC)
	psignal(sig,"SIGALRM handler");
#endif
}

int Dselect(int numfds, fd_set *r, fd_set *w, fd_set *x, struct timeval *tv) {
	int i;
	struct itimerval itv,otv;
	
	itv.it_interval.tv_sec = 0;
	itv.it_interval.tv_usec = 0;
	itv.it_value.tv_sec = *tv.tv_sec + (*tv.tv_usec / 1000000) + 1;
	itv.it_value.tv_usec = *tv.tv_usec % 1000000;
	Dsigset(SIGALRM,alrm_handler);
	setitimer(ITIMER_REAL,&itv,NULL);

	i = select(31,&ri,NULL,NULL,tv);

	itv.it_value.tv_sec = 0;
	itv.it_value.tv_usec = 0;
	setitimer(ITIMER_REAL,&itv,&otv);
	Dsigset(SIGALRM,SIG_IGN);
	if (otv.it_value.tv_sec >= 1) {
		*tv.tv_sec = otv.it_value.tv_sec - 1;
		*tv.tv_usec = otv.it_value.tv_usec;
	} else {
		*tv.tv_sec = 0;
		*tv.tv_usec = 0;
	}

	return i;
}
#else
#error Error in Makefile - OR - You need to do something about select(3)
#endif
