#if 0
drealmBBS - Bulletin Board System for Linux
Copyright (C) 1994, 1995  Inge Cubitt and Peter Jones

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The GNU General Public License should be in a file called COPYING.
#endif

/* ANSI headers */
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "display.h"

struct _mail_header {
	char *parent;	/* Message this is a reply to */
	char *flag;	/* 'R' for read, 'U' for unread */
	char *hash;	/* "#" */
	char *this;	/* Message number for display */
	char *dname;	/* Day name */
	char *mname;	/* Month name */
	char *dom;	/* Day of month */
	char *time;	/* Time of day */
	char *tzname;	/* Timezone */
	char *year;	/* Year */
	char *from;	/* "from" */
	char *fromname;	/* name of sender */
	char *to;	/* "to" */
	char *toname;	/* Name of sender of parent */
	char *dash;	/* "-" */
	char *subject;	/* multi-word subject */
};

static struct _mail_header mail_header;

static void print_mail_message(char *usersdir, char *user, char *msgno);
static int parse_mail_header(char *filename);
static void print_mail_header(void);
static void print_mail_body(char *filename);

int main(int argc, char *argv[]) {
/* LENGTHS CHECKED */
	if ((argc < 4) || (argc > 5)) {
#if defined(DEVEL)
		(void)fprintf(stderr,"Syntax: %s usersdir user msgno\n",argv[0]);
#endif
		return 1;
	}
	print_mail_message(argv[1],argv[2],argv[3]);
	if (argc == 5) page_file(argv[4]);
	return 0;
}

static void print_mail_message(char *usersdir, char *user, char *msgno) {
/* LENGTHS CHECKED */
	char *filename;

	filename = (char *)malloc(strlen(usersdir) + strlen(user) + strlen(msgno) + 13 /* fixed bit */);

	get_LW(1);

	TOT_LINES = 0;
	/*if (!LINES)*/ {
		(void)printf("\nMail:\n");
		TOT_LINES += 2;
	}
	(void)sprintf(filename,"%s/%s/.mail/hdr.%s",usersdir,user,msgno);
	if (parse_mail_header(filename)) print_mail_header();
	else {
		(void)printf("Could not read %s\n",filename);
		TOT_LINES += 1;
	}
	(void)sprintf(filename,"%s/%s/.mail/msg.%s",usersdir,user,msgno);
	print_mail_body(filename);
	free(filename);
}

static int parse_mail_header(char *filename) {
/* LENGTHS CHECKED */
	static char header[1024];
	char *p, *q;
	FILE *HDR = fopen(filename,"r");

	if (!HDR) {
#if defined(DEVEL)
		perror("fopen header");
#endif
		return 0;
	}

	fread(header,sizeof (char),1024,HDR);
	if (ferror(HDR)) {
#if defined(DEVEL)
		perror("fread header");
#endif
		return 0;
	}
	p = header;

	for(q = p; !isspace(*p); p++); mail_header.parent = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.flag = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.hash = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.this = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.dname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.mname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.dom = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.time = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.tzname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.year = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.from = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.fromname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.to = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.toname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); mail_header.dash = q;
	for(;isspace(*p); *p++='\0');

	mail_header.subject = p;

	return 1;
}

static void print_mail_header(void) {
/* LENGTHS CHECKED */
	struct _mail_header *h = &mail_header;
	(void)printf("%s %s %s %s %s %s %s %s %s %s %s %s\n",
		h->this, h->dname, h->mname, h->dom, h->time, h->year,
		h->from, h->fromname,
		strcmp(h->parent,"base") ? "reply-to" : "-",
		strcmp(h->parent,"base") ? h->parent : "-",
		strcmp(h->parent,"base") ? "by" : "to",
		h->toname);
	(void)printf("Subject: %s",mail_header.subject);
	(void)printf("\n");
	TOT_LINES += 3;
}

static void print_mail_body(char *filename) {
/* LENGTHS CHECKED */
	FILE *BODY;

	if (!(BODY=fopen(filename,"r"))) {
#if defined(DEVEL)
		perror("fopen body");
#endif
		return;
	}
	(void)pager(BODY,1);	/* always paginate */
}
