(setq text-mode-hook 'turn-on-auto-fill)
(setq make-backup-files nil) 
(put 'eval-expression 'disabled nil) 

;; S=shift, C=control 
(global-set-key [f1] 'help-for-help)
(global-set-key [S-f1] 'apropos)
(global-set-key [C-f1] 'describe-key)
(global-set-key [C-S-f1] 'describe-function)
(global-set-key [f2] 'scroll-other-window) 
(global-set-key [S-f2] 'center-line)
(global-set-key [f3] 'isearch-forward)
(global-set-key [S-f3] 're-search-forward)
(global-set-key [f4] 'query-replace)
(global-set-key [S-f4] 'query-replace-regexp)
(global-set-key [f5] 'global-set-key)
(global-set-key [S-f5] 'font-lock-mode)
(global-set-key [f6] 'calc)
(global-set-key [f7] 'mtex-insert-typewriter)
(global-set-key [S-f7] 'mtex-insert-roman)
(global-set-key [f8] 'mtex-insert-italic)
(global-set-key [S-f8] 'mtex-insert-bold)
(global-set-key [C-f8] 'mtex-insert-brackets)
(global-set-key [f9] 'save-buffer)
(global-set-key [S-f9] 'latex-mode)
(global-set-key [C-f9] 'plain-tex-mode)
(global-set-key [f10] 'buffer-menu)
(global-set-key [f11] 'eval-print-last-sexp)
(global-set-key [f12] 'goto-line)
(global-set-key [C-up] 'backward-paragraph)
(global-set-key [C-down] 'forward-paragraph)
(global-set-key [C-left] 'backward-word)
(global-set-key [C-right] 'forward-word)
(global-set-key [C-prior] 'beginning-of-buffer)
(global-set-key [C-next] 'end-of-buffer)
(global-set-key [home] 'beginning-of-line)
(global-set-key [end] 'end-of-line)
(global-set-key [C-insert] 'insert-file)
(global-set-key [mouse-3] 'mouse-save-then-kill)
(global-set-key [mode-line mouse-2] 'mouse-tear-off-window)


(setq auto-mode-alist (append '(("\\.texi$" . tex-mode)) auto-mode-alist))
(setq auto-mode-alist (append '(("\\.mf$" . tex-mode)) auto-mode-alist))

;;; Commands added by calc-public-autoloads on Tue Jun  1 10:52:18 1993.
(autoload 'calc-dispatch	   "calc" "Calculator Options" t)
(autoload 'full-calc		   "calc" "Full-screen Calculator" t)
(autoload 'full-calc-keypad	   "calc" "Full-screen X Calculator" t)
(autoload 'calc-eval		   "calc" "Use Calculator from Lisp")
(autoload 'defmath		   "calc" nil t t)
(autoload 'calc			   "calc" "Calculator Mode" t)
(autoload 'quick-calc		   "calc" "Quick Calculator" t)
(autoload 'calc-keypad		   "calc" "X windows Calculator" t)
(autoload 'calc-embedded	   "calc" "Use Calc inside any buffer" t)
(autoload 'calc-embedded-activate  "calc" "Activate =>'s in buffer" t)
(autoload 'calc-grab-region	   "calc" "Grab region of Calc data" t)
(autoload 'calc-grab-rectangle	   "calc" "Grab rectangle of data" t)
(autoload 'edit-kbd-macro	   "macedit" "Edit Keyboard Macro" t)
(autoload 'edit-last-kbd-macro	   "macedit" "Edit Keyboard Macro" t)
(autoload 'read-kbd-macro	   "macedit" "Read Keyboard Macro" t)
(setq load-path (append load-path (list "/usr/lib/emacs/site-lisp/calc")))
(global-set-key "\e#" 'calc-dispatch)
;;; End of Calc autoloads.


;;; Mode settings stored by Calc on Wed Jun  2 11:56:42 1993
(setq calc-complex-format 'i)
(setq calc-angle-mode 'rad)
(setq calc-language 'tex)
;;; End of mode settings

;; if you like colors:
;  (load-file "/usr/lib/emacs/site-lisp/hilit19.el")
;  (add-hook 'find-file-hooks 'hilit-highlight-after-find t)
;  (setq hilit-auto-highlight-maxout 200000) ; set a higher autohighlight max

;what shell to use:
    (setq shell-file-name "/bin/bash")

;not needed with auc-tex

    (defun mft-buffer ()
    (interactive)
    (start-process "mft" "out" "mft" (buffer-name) "-s" "/book/mplain.mft"))

    (defun mf-buffer ()
    "run METAFONT on the buffer"
    (interactive)
    (start-process "mf" "METAFONT" "mf" "screenstrokes; input " (buffer-name)))

    (defun mtex-buffer ()
    (interactive)
    (start-process "tex" "out" "tex" (buffer-name)))

;    (defun mtex-insert-bold (s) "insert bold text."
;    (interactive "sBold text:  ")
;    (insert "{\\bf ") (insert s) (insert "}"))

    (defun mtex-insert-bold (s) "insert bold text."
    (interactive "sBold text:  ")
    (insert "<b> ") (insert s) (insert "</b>"))

;    (defun mtex-insert-italic (s) "insert italic text."
;    (interactive "sItalic text:  ")
;    (insert "{\\it ") (insert s) (insert "}"))
;
;    (defun mtex-insert-typewriter (s) "insert typewriter text."
;    (interactive "sTypewriter text:  ")
;    (insert "{\\tt ") (insert s) (insert "}"))
;
;    (defun mtex-insert-roman (s) "insert roman text."
;    (interactive "sRoman text:  ")
;    (insert "\\rm ") (insert s) (insert "}"))

    (defun mtex-insert-italic (s) "insert italic text."
    (interactive "sItalic text:  ")
    (insert "<i> ") (insert s) (insert "</i>"))

    (defun mtex-insert-typewriter (s) "insert typewriter text."
    (interactive "sTypewriter text:  ")
    (insert "<tt> ") (insert s) (insert "</tt>"))

    (defun mtex-insert-roman (s) "insert roman text."
    (interactive "sRoman text:  ")
    (insert "<pre> ") (insert s) (insert "</pre>"))

    (defun mtex-insert-brackets (s) "insert command."
    (interactive "sCommand:  ")
    (insert "<") (insert s) (insert ">"))


;; default size of torn-off frames
    (setq default-frame-alist 
          (append (list 
                   '(width . 81)
                   (cond 
                    ((> (x-display-pixel-height) 1023) '(height . 32))
                    ((> (x-display-pixel-height)  899) '(height . 27))
                    (t                                 '(height . 26)))
                   )
                  default-frame-alist))



(defun space-then-fill (fillp)
  "Insert SPACE then fill-paragraph"
  (interactive "P")
  (insert " ")
  (fill-paragraph fillp)
  (if (eolp)
                (insert " ")
         )
)

;then use:
;  (local-set-key " " 'space-then-fill)
; to use it, ie for auto filling of paragraphs as
; one goes along


; (load-file "/usr/lib/emacs/site-lisp/auctex/tex-site.elc")
;   (load "auc-tex") ;for old keymappings
;   (setq-default TeX-master t)
;   (setq TeX-auto-global nil)
;     (setq-default TeX-parse-self nil) ; Disable parse on load.
;     (setq-default TeX-auto-save nil) ; Disable parse on save.

;;colors for point and pointer
(if (equal window-system 'x)
          (progn
            (transient-mark-mode 1) ;highlighting on
            (display-time) ;display time and Mail
            ;(setq baud-rate 19200) ; used to be a bug under X
            ;(set-default-font "10x20")
            (set-border-color "blue")
            (set-foreground-color "Black")
            (set-background-color "bisque")
            (set-cursor-color "blue")
            ;;needs set-mouse-color to be effective
            (setq x-pointer-shape x-pointer-left-ptr)
            (set-mouse-color "green3")
            ;(menu-bar-mode -1) ;no menus
            ;(toggle-scroll-bar -1)  ;no scroll bars
          ))

