/* generic test skeleton */

#include "lp.h"
plp_signal_t cleanup (int sig) { ; }

/* Test Checkperm and its subroutines */

void do_tests (void) {
    int perms = 'R';

    /* check hostname matching with domain */
    do_test ("perms (basic)", 
    Checkperm ("overload.iona.ie", "jmason", "t_perms_1", &perms, 0, 0) > 0);

    do_test ("perms (basic) (inverse)", 
    Checkperm ("ftp.uu.net", "jmason%iona.ie", "t_perms_1", &perms, 0, 0) <= 0);

    /* check hostname matching without domain */
    do_test ("perms without domain", 
    Checkperm ("overload", "jmason", "t_perms_1", &perms, 0, 0) > 0);

    do_test ("perms without domain (inverse)",
    Checkperm ("not_a_real_host", "jmason", "t_perms_1", &perms, 0, 0) <= 0);

    /* check case insensitivity */
    do_test ("perms with funny case",
    Checkperm ("OvERloAd", "jmason", "t_perms_1", &perms, 0, 0) > 0);

    /* check matching on username */
    do_test ("perms with username",
    Checkperm ("overload.iona.ie", "jmason", "t_perms_1", &perms, 0, 0) > 0);

    do_test ("perms with username (inverse)",
    Checkperm ("overload.iona.ie", "nobody", "t_perms_1", &perms, 0, 0) <= 0);

    /* check matching on groupname */
    do_test ("perms with group",
    Checkperm ("overload.iona.ie", "jmason", "t_perms_2", &perms, 0, 0) > 0);

    do_test ("perms with group (inverse)",
    Checkperm ("overload.iona.ie", "nobody", "t_perms_2", &perms, 0, 0) <= 0);

    /* check wildcard matching */
    do_test ("perms wildcards (user)",
    Checkperm ("overload.iona.ie", "jmason", "t_perms_3_u", &perms, 0, 0) > 0);

    do_test ("perms wildcards (user) (inverse)",
    Checkperm ("overload.iona.ie", "nobody", "t_perms_3_u", &perms, 0, 0) <= 0);

    do_test ("perms wildcards (group)",
    Checkperm ("overload.iona.ie", "jmason", "t_perms_3_g", &perms, 0, 0) > 0);

    do_test ("perms wildcards (group) (inverse)",
    Checkperm ("overload.iona.ie", "nobody", "t_perms_3_g", &perms, 0, 0) <= 0);

    do_test ("perms wildcards (queue)",
    Checkperm ("overload.iona.ie", "jmason", "t_perms_3_q_foobar", &perms, 0, 0) > 0);

    do_test ("perms wildcards (queue) (inverse)",
    Checkperm ("overload.iona.ie", "nobody", "t_perms_3_q_foobar", &perms, 0, 0) <= 0);

    do_test ("perms without host", 
    Checkperm (NULL, "jmason", "t_perms_1", &perms, 0, 0) > 0);

    do_test ("perms without username", 
    Checkperm ("overload", NULL, "t_perms_1", &perms, 0, 0) > 0);
}

main (int argc, char **argv) {
    char *Label, *Testdir;
    char New_permfile[BUFSIZ];

    Readconf();
    Parse_debug ((argc > 1) ? argv[1] : "0");

    if ((Testdir = getenv ("TESTDIR")) == NULL) {
	fprintf (stderr, "TESTDIR not set!"); exit(1);
    }
    (void) sprintf (New_permfile, "%s/%s", Testdir, "perms.tst");
    free (Permfile_path); Permfile_path = New_permfile;

    create_pc_cache ();
    create_perm_cache ();

    printf ("[testing with cache off]\n");	Use_perm_cache = 0; do_tests ();
    printf ("[testing with cache on]\n");	Use_perm_cache = 1; do_tests ();
    printf ("[cache off to stress-test]\n");	Use_perm_cache = 0; do_tests ();

    return 0;
}
