/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lprm.c
 * lprm- remove files
 ***************************************************************************/

#include "lp.h"
#include "common/rmjob.h"
#include "library/errormsg.h"
#include "library/readconf.h"
#include "patchlevel.h"

static int all_flag;

static void Dienoarg(int option) {
    Diemsg ("option '%c' missing argument", option);
}

static void Usemsg(void)
{
    (void) fprintf (stderr,
	"Usage: lprm [-Pprinter] [-] [-Dn] [job # ... ] [ user ... ]\n");
}

plp_signal_t cleanup(int signal) { exit (1); }

/***************************************************************************
 * 1. pick off the options
 * 2. set up the parameters
 ***************************************************************************/

static void Lprm_parms(int argc, char *argv[])
{
    int option;
    char *s;

    while ((option = Getopt (argc, argv, "P:D:a")) != EOF) {
	switch (option) {
	case 'D':
	    if (!Optarg || !*Optarg) {
		Dienoarg (option);
	    }
	    if (Debug) {
		Diemsg ("Duplicate -D option");
	    }
	    Parse_debug (Optarg);
	    break;
	case 'P':
	    if (!Optarg || !*Optarg) {
		Dienoarg (option);
	    }
	    if (Printer) {
		Diemsg ("Duplicate -P option");
	    }
	    Printer = Optarg;
	    break;
	case 'a':
	    if (all_flag) {
		Diemsg ("Duplicate -a option");
	    }
	    all_flag = 1;
	    break;
	case '?':
	    Usemsg ();
	    break;
	default:
	    fatal (XLOG_INFO, "Lprm_parms: badparm %c", option);
	}
    }

    /*
     * set up the Parms[] array
     */
    allocParmsIfNeeded ();
    for (; Optind < argc; ++Optind) {
	s = argv[Optind];
	Parms[Parmcount].str = s;
	if (isdigit (*s)) {
	    Parms[Parmcount].num = atoi (s);
	} else {
	    fatal (XLOG_INFO,
		"Bad job specification \"%s\" - must be a number.", s);
	}
	++Parmcount;
	growParmsIfNeeded ();
    }
}

int main(int argc, char *argv[], char *envp[])
{
    struct passwd *pw_ent;	/* user entry in /etc/passwd */
    int i;

    /*
     * set umask to avoid problems with user umask
     */
    (void) umask (0);
    set_user_uid (0);
    root_to_user ();

    if ((pw_ent = getpwuid (UserUID)) == 0) {
	logerr_die (XLOG_INFO, "getpwuid failed on uid %d", UserUID);
    }

    /*
     * setup parameters
     */
    Lprm_parms (argc, argv);
    Std_environ (argc, argv, envp);
    Readconf ();

    /*
     * get the default printer
     */
    Get_Printer (0);
    /*
     * check for the all option
     */
    if (all_flag) {
	if (Parmcount > 0) {
	    Diemsg ("-a cannot be combined with other options");
	}
	Parms[0].str = "-all";
	Parmcount = 1;
    }
    if (Debug > 4) {
	(void) fprintf (stdout, "Printer %s, Parmcount %d ", Printer, Parmcount);
	for (i = 0; i < Parmcount; ++i)
	    (void) fprintf (stdout, " '%s'(%d)", Parms[i].str, Parms[i].num);
	(void) fprintf (stdout, "\n");
	(void) fflush (stdout);
    }

    /*
     * set up the From information
     */
    FQDN = Host;
    From = ShortHost;
    /*
     * get the user information
     */
    if ((pw_ent = getpwuid (UserUID)) == 0) {
	logerr_die (XLOG_INFO, "getpwuid failed on uid %d", UserUID);
    }

    assert(strlen(pw_ent->pw_name)<sizeof(LOGNAME));
    (void) strcpy (LOGNAME, pw_ent->pw_name);
    Person = LOGNAME;

    if (UserUID == 0) {
	/* we are being invoked by root */
	Is_root = 1;
    }
    /*
     * set signals
     */
    (void) plp_signal (SIGPIPE, (plp_sigfunc_t)SIG_IGN);
    (void) plp_signal (SIGHUP, cleanup);
    (void) plp_signal (SIGINT, cleanup);
    (void) plp_signal (SIGQUIT, cleanup);
    (void) plp_signal (SIGTERM, cleanup);
    if (Parmcount != 0) {
	rmjob ();
    }
    return 0;
}
