/***************************************************************************
 * pjif.c: interface filter for HP PaintJet (XL)
 * AJCD March 1991, adapted from:

#ifndef lint
static char id_str1[] =
	"$Header: /disk/home/src2/plp/work_area/filters/RCS/pjif.c,v 1.1 1991/12/13 16:35:13 ajcd Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>

extern int errorcode;
/* set from flags */
extern int debug, width, length, xwidth, ylength, literal, indent, special;
extern char *zopts, *class, *job, *login, *accntname, *host, *accntfile;
extern char *printer, *format, *name;
extern int npages;	/* number of pages */
extern char *calloc();	/* memory allocation */

/* variables for special options */
static int manualfeed = 0;
static int printmode = 0;
static int pagesize = 0;

cleanup() {
        printf("\033E");
}

filter(stop)
	char *stop;
{
	int c, i;
	int lines = 0;
	int binary = 0;
	int parsing = 0;
	int printed = 0;
	int state = 0;
	int value, vflags;
	char pattern[5];

	if (zopts) {      /* search comma separated list */
	   char *s, *next;
	   for (s = zopts; s && *s; s = next) {
	      if (next = strchr(s, ','))
		 *next++ = '\0';
	      if (!strcmp(s, "manualfeed"))
		 manualfeed = 1;
	      else if (!strcmp(s, "transparency"))
		 printmode = 1;
	      else if (!strcmp(s, "presentation"))
		 printmode = 2;
	      else if (!strcmp(s, "a4"))
		 pagesize = 26;
	      else if (!strcmp(s, "a3"))
		 pagesize = 27;
	      else {
		 (void)fprintf(stderr, "%s: unrecognised option: -Z%s\n",
			       name, s);
		 (void)fflush(stderr);
	      }
	   }
	}

	/*
	 * do whatever initializations are needed
	 */
	printf("\033E");                /* reset */
	if (pagesize)                      /* page size & type */
	   printf("\033&/%dA", pagesize);
	if (manualfeed)                    /* manual/tray feed */
	   printf("\033&/2H");
	if (printmode == 1)                 /* transparency */
	   printf("\033&k3W");
	else if (printmode == 2)            /* presentation */
	   printf("\033*o1Q");

	npages = 1;
	strcpy(pattern, "...\n"); /* data command patterns */

	/* should parse all page-ejecting and printing commands */
	while( (c = getchar()) != EOF ){
	        switch (parsing) {
		case 0: /* previous char was normal */
		   if (!binary) {
		      switch ( c ) {
		      case '\n': ++lines;
			 if( lines > length ){
			    lines -= length;
			    ++npages;
			 }
			 break;
		      case '\f': ++npages;
			 printed = 0;
			 break;
		      case '\033': ++parsing;
		      case 0: case 7: case 8: case 9: case 11:
		      case '\r': case 14: case 15: case ' ':
			 break;
		      default:
			 printed = 1;
		      }
		   } else
		      binary--;
		   break;
		case 1: /* previous char was ESC */
		   if (c >= '!' && c <= '/') { /* parameterised command */
		      pattern[0] = c;
		      ++parsing;
		   } else { /* act on two-character ESC sequence */
		      if (printed && c == 'E') {
			 ++npages;
			 printed = 0;
		      }
		      parsing = 0;
		   }
		   break;
		case 2: /* parameterised command: group character */
		   pattern[1] = c;
		   value = vflags = 0;
		   ++parsing;
		   break;
		case 3: /* parameterised command: value field */
		   if (c == '-' || c == '.')
		      vflags = 1;          /* can't be byte count */
		   else if (c >= '0' && c <= '9' && !vflags)
		      value = value*10 + c-'0';
		   else if (c >= 64 && c <= 126) {
		      pattern[2] = (c & ~32);   /* ignore data */
		      if (strstr("*bV\n*bW\n*vW\n)sW\n(sW\n", pattern))
			 binary += value;
		      if (printed &&            /* partial page eject */
			  strstr("&/P\n&/A\n&/H\n&/O\n", pattern)) {
			 npages++;
			 printed = 0;
		      } else if (!printed &&    /* graphics on page? */
				 strstr("*rA\n", pattern)) {
			 printed = 1;
		      }
		      if (c >= 96 && c <= 126) /* continued */
			 value = vflags = 0; /* next value */
		      else /* terminated */
			 parsing = 0;
		   }
		   break;
		}
		if( !parsing && (stop || state) ){
		   if( c == stop[state] ){
		      ++state;
		      if( stop[state] == 0 ){
			 state = 0;
			 if( fflush(stdout) ){
			    logerr_die( "fflush returned error" );
			 }
			 suspend();
		      }
		   } else if( state ){
		      for( i = 0; i < state; ++i ){
			 putchar(stop[i]);
		      }
		      state = 0;
		      putchar(c);
		   } else {
		      putchar(c);
		   }
		} else {
		   putchar(c);
		}
	}
	if( ferror( stdin ) ){
		logerr_die( "read error on stdin");
	}
	for( i = 0; i < state; ++i ){
		putchar(stop[i]);
	}
	if( lines > 0 ){
		++npages;
	}
	if( fflush(stdout) ){
		logerr_die( "fflush returned error" );
	}

	/* tidy up afterwards */
	printf("\033E");
}
