/***************************************************************************
 * citohif.c: interface filter for C.Itoh matrix printer
 * AJCD March 1991, adapted from:

#ifndef lint
static char id_str1[] =
	"$Header: /disk/home/src2/plp/work_area/filters/RCS/citohif.c,v 1.1 1993/02/23 11:46:18 ajcd Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>

extern int errorcode;
/* set from flags */
extern int debug, width, length, xwidth, ylength, literal, indent, special;
extern char *zopts, *class, *job, *login, *accntname, *host, *accntfile;
extern char *printer, *format, *name;
extern int npages;	/* number of pages */
extern char *calloc();	/* memory allocation */

#define NORM_LPI 2 /*6 lpi*/
#define NORM_CPI 1 /*12 cpi */
#define NORM_QUAL 0 /* draft */

/* variables for special options */
static int quality = NORM_QUAL;
static int cpi = NORM_CPI;
static int lpi = NORM_LPI;

static int column = 0;
static int lines = 0;

static int lpi_table[] = {3, 4, 6, 8};
static int cpi_table[] = {30, 35, 40, 50};  /* cpi*3 */

linefeed() {
   if( ++lines > length ) { /* linefeed */
      lines -= length;
      ++npages;
   }
   putchar('\n');
   putchar('\r');
   column = 0;
}

cleanup() {
}

filter(stop)
	char *stop;
{
	int c, i;
	int state = 0;

	if (zopts) {      /* search comma separated list */
	   char *s, *next;
	   for (s = zopts; s && *s; s = next) {
	      if (next = strchr(s, ','))
		 *next++ = '\0';
	      if (!strcmp(s, "letter"))
		 quality = 2;
	      else if (!strcmp(s, "draft"))
		 quality = 0;
	      else if (!strncmp(s, "cpi=", 4)) {
		 if (sscanf(s, "cpi=%d", &cpi) != 1)
		    fatal( "bad option %s", s );
		 switch (cpi) {
		 case 10: cpi = 0; break;
		 case 12: cpi = 1; break;
		 case 13: cpi = 2; break;
		 case 17: cpi = 3; break;
		 default: fatal( "bad cpi %d", cpi );
		 }
	      } else if (!strncmp(s, "lpi=", 4)) {
		 if (sscanf(s, "lpi=%d", &lpi) != 1)
		    fatal( "bad option %s", s );
		 switch (lpi) {
		 case 3: lpi = 0; break;
		 case 4: lpi = 1; break;
		 case 6: lpi = 2; break;
		 case 8: lpi = 3; break;
		 default: fatal( "bad lpi %d", lpi );
		 }
	      } else {
		 (void)fprintf(stderr, "%s: unrecognised option: -Z%s\n",
			       name, s);
		 (void)fflush(stderr);
	      }
	   }
	}

	/*
	 * do whatever initializations are needed
	 */
	if (cpi != NORM_CPI)                /* characters per inch */
	   printf("\033?\"%c", cpi+' ');
	if (lpi != NORM_LPI)                /* lines per inch */
	   printf("\033?!%c", lpi+' ');
	if (quality != NORM_QUAL)                /* quality */
	   printf("\033?#%c", quality+' ');

	npages = 0;
	length = length*lpi_table[lpi]/lpi_table[NORM_LPI];
	width = width*cpi_table[cpi]/cpi_table[NORM_CPI];

	/* should parse all page-ejecting and printing commands */
	while( (c = getchar()) != EOF ){
		if( stop || state ){
		   if( c == stop[state] ){
		      ++state;
		      if( stop[state] == 0 ){
			 state = 0;
			 if( fflush(stdout) ){
			    logerr_die( "fflush returned error" );
			 }
			 suspend();
		      }
		   } else if( state ){
		      for( i = 0; i < state; ++i ){
			 dochar(stop[i]);
		      }
		      state = 0;
		      dochar(c);
		   } else {
		      dochar(c);
		   }
		} else {
		   dochar(c);
		}
	}
	if( ferror( stdin ) ){
		logerr_die( "read error on stdin");
	}
	for( i = 0; i < state; ++i ){
		dochar(stop[i]);
	}
	dochar('\f');
	if( lines > 0 ){
		++npages;
	}
	if( fflush(stdout) ){
		logerr_die( "fflush returned error" );
	}

	/* tidy up afterwards */
	if (cpi != NORM_CPI)                /* characters per inch */
	   printf("\033?\"%c", cpi+' ');
	if (lpi != NORM_LPI)                /* lines per inch */
	   printf("\033?!%c", lpi+' ');
	if (quality != NORM_QUAL)                /* quality */
	   printf("\033?#%c", quality+' ');
}

dochar(c)
     int c;
{
   static int last = -1;

   switch (c) {
   case '\f':
      if (last != '\f') {
	 if (last != '\n') {
	    if (last != '\r')
	       putchar('\r');
	    putchar('\n');
	    if( ++lines > length ){
	       lines -= length;
	       ++npages;
	    }
	 }
	 putchar(c);
	 ++npages;
      }
      column = 0;
      break;
   case '\n':
      linefeed();
      break;
   case '\r':
      column = 0;
   case '\016': case '\017': case '\033':
      putchar(c);
      break;
   case '\t':
      {  int extra = 8-(column&7);
	 while (extra--) {
	    if (++column > width) {
	       linefeed();
	       column = 1;
	    }
	    putchar(' ');     /* always one space */
	 }
      }
      break;
   default:
      if ((c >= ' ' && c <= '~') || (c >= 0xa0 && c <= 0xff)) {
	 if (++column > width) {
	    linefeed();
	    column = 1;
	 }
	 putchar(c);
      }
   }
   last = c;
}
