/*
 * printers: print out contents of printcap files
 * 
 * printers [-l] [-L] [-e] [printer[@domain]] -l - long listing - some information -L - long
 * listing - all information -e - use exact match
 */

#include "lp.h"
#include "library/readconf.h"
#include "library/utils.h"

static int longl, verylong, exact;

static void
usage (void) {
    (void) fprintf (stdout, "Usage:\tprinters [-e] [-l] [-L] [printer[@domain]]\n\n");
    (void) fprintf (stdout, "where\n");
    (void) fprintf (stdout, "\t-e causes the printer name to be matched exactly\n");
    (void) fprintf (stdout, "\t-l gives some information about the printer, e.g. alias names\n");
    (void) fprintf (stdout, "\t-L gives full information about the printer\n");
    (void) fprintf (stdout, "\t-? or -h print out this usage message\n\n");
    (void) fprintf (stdout, "If no printer is specified then all the printers in the domain will be listed.\n");
    (void) fprintf (stdout, "If the printer name is appended with @domain the printer is looked up in that\n");
    (void) fprintf (stdout, "domain using HESIOD or NIS. If only the @domain part is specified, all of the\n");
    (void) fprintf (stdout, "printers in that domain are listed.\n");
    exit (1);
}

/*
 * catpent: get the printcap entry end print it
 */
static void
catpent (char *name) {
    char *cp;

    if (Get_pc_entry (name, All_pc_vars, All_pc_len) == 0) {
	(void) fprintf (stdout, "no printer %s\n", name);
	return;
    }
    cp = strrchr (All_names, '|');
    if (cp != NULL && !strncmp (cp + 1, "TEST", 4) && !(longl || verylong))
	return;
    if (cp == NULL)
	(void) fprintf (stdout, "%s ", name);
    else
	(void) fprintf (stdout, "%-14s(%s) ", name, cp + 1);

    if ((longl) || (verylong)) {
	(void) fprintf (stdout, "\n");
	if (cp != NULL)
	    *cp = '\0';
	if ((cp = strchr (All_names, '|')) != NULL) {
	    do {
		*cp = ',';
	    } while ((cp = strchr (All_names, '|')) != NULL);
	    (void) fprintf (stdout, "\taliases : %s\n", All_names);
	}
	(void) fprintf (stdout, "\tspool directory : %s\n", SD);
	if (RM && *RM)
	    (void) fprintf (stdout, "\tremote spooling host : %s\n", RM);
	if (RP && *RP)
	    (void) fprintf (stdout, "\tremote printer name : %s\n", RP);
#ifdef EUCS_ZOPTIONS
	if (FL && *FL)
	    (void) fprintf (stdout, "\tvalid forms : %s\n", FL);
#endif
	if (MX > 0)
	    (void) fprintf (stdout, "\tfile size limit : %d KBytes\n", MX);

	if (verylong) {
	    if (LP && *LP)
		(void) fprintf (stdout, "\tdevice : %s\n", LP);
	    if (LF && *LF)
		(void) fprintf (stdout, "\tlog file : %s\n", LF);
	    if (LO && *LO)
		(void) fprintf (stdout, "\tlock file : %s\n", LO);
	    if (AF == 0 || *AF == 0)
		(void) fprintf (stdout, "\tno accounting file\n");
	    else
		(void) fprintf (stdout, "\taccounting file : %s\n", AF);
	    if (ST && *ST)
		(void) fprintf (stdout, "\tstatus file : %s\n", ST);
	    if (PS && *PS)
		(void) fprintf (stdout, "\tprinter status file : %s\n", PS);
	    if (EU)
		(void) fprintf (stdout, "\tEUCS printer spooler used\n");
	    else if (BK)
		(void) fprintf (stdout, "\tBSD printer spooler used\n");
	    else
		(void) fprintf (stdout, "\tPLP printer spooler used\n");
#ifdef EUCS_ZOPTIONS
	    if (ED)
		(void) fprintf (stdout, "\texpensive device\n");
#endif
	}
    }
    (void) fprintf (stdout, "\n");
}

int
main (int argc, char **argv, char **envp) {
    char **prlist;
    int option;

    longl = verylong = exact = 0;

    while ((option = Getopt (argc, argv, "D:lLe?h")) != EOF) {
	switch (option) {
	case 'D':		/* Debugging */
	    Parse_debug (Optarg);
	    break;
	case 'l':		/* long listing */
	    ++longl;
	    break;
	case 'L':		/* very long listing */
	    ++verylong;
	    break;
	case 'e':		/* exact match of printer name */
	    ++exact;
	    break;
	case '?':
	case 'h':
	default:
	    usage ();
	    break;
	}
    }
    if (Optind < argc) {
	Printer = argv[Optind];
	++Optind;
    }
    if (Optind < argc) {
	usage ();
    }
    Std_environ (argc, argv, envp);
    Readconf ();

#ifdef HESIOD
    if (Printer && *Printer == '@') {
	for (prlist = All_printers_zone (Printer + 1);
	     (prlist && *prlist); ++prlist) {
	    char buf[BUFSIZ];
	    strcpy (buf, *prlist);
	    if (out_domain) {
		strcat (buf, "@");
		strcat (buf, out_domain);
	    }
	    catpent (buf);
	}
    } else
#endif
    if (Printer && (exact || strchr (Printer, '@')))
	catpent (Printer);
    else {
	for (prlist = All_printers (); (prlist && *prlist); ++prlist) {
	    if (Printer) {
		if (strstr (*prlist, Printer))
		    catpent (*prlist);
	    } else {
		catpent (*prlist);
	    }
	}
    }
    return 0;
}

plp_signal_t cleanup (int signal) { exit (1); }
