/*
 * lp-pipe.c: PLP LP-pipe miscellaneous functions.
 *
 *                              -- Justin Mason 26 Aug 94.
 */

#include "lp-pipe.h"	/* from PLP src directory, for OS-specific stuff */
#include <sys/types.h>
#include <sys/file.h>
#ifndef O_CREAT
#include <sys/fcntl.h>
#endif
#include <stdarg.h>

char *status_fname = NULL;

/* setstatus: put a message in the "status" file, if available. */

/* VARARGS2 */
void
#ifdef __STDC__
setstatus (char *msg,...)
#else
setstatus (va_alist) va_dcl
#endif
{
#ifndef __STDC__
    char *msg;
#endif
    static int fd = -1;
    char buf[255];
    int i;
    VA_LOCAL_DECL

    if (status_fname && *status_fname) {
	if (fd < 0) {
	    fd = open (status_fname, O_WRONLY | O_CREAT | O_TRUNC);
	    if (fd < 0) {
		fprintf (stderr, "couldn't open '%s': %s\n", status_fname, ERRSTR);
		return;
	    }
	} else {
	    (void) lseek (fd, (off_t) 0, SEEK_SET);
	}
	ftruncate (fd, (off_t) 0);	/* nuke the original contents */
	VA_START (msg);
	VA_SHIFT (msg, char *);
	(void) vsprintf (buf, msg, ap);
	VA_END;
	(void) strcat (buf, "\n");
	i = strlen (buf);
	if (write (fd, buf, i) != i) {
	    fprintf (stderr, "couldn't write to '%s': %s\n", status_fname, ERRSTR);
	}
    }
}
