
#define CF_UNKNOWN		0
#define CF_LPDLOG		1
#define CF_LPDLOCK		2
#define CF_SENDMAIL		3
#define CF_USER			4
#define CF_DEFAULTPRINTCAP	5
#define CF_PRINTCAP		6
#define CF_PPERMS		7
#define CF_FILTERPATH		8
#define CF_FILTERLDPATH		9
#define CF_PRIVPORTS		10
#define CF_RESTRICTSYMLINKS	11
#define CF_MAILFORMAT		12
#define CF_ZOPTIONS		13
#define CF_COSTCODES		14
#define CF_HESPCAPKEY		15
#define CF_HESCOSTCODEKEY	16
#define CF_NISPRINTCAP		17
#define CF_NISCOSTCODE		18
#define CF_PRINTERPORT		19
#define CF_FROMADDRESS		20
#define CF_MAILONERR		21
#define CF_ERRORSFILE		22
#define CF_MINFREEFILE		23
#define CF_FORMSFILE		25
#define CF_LIMITSFILE		26
#define CF_BANNERFMT		27
#define CF_PCAPORDER		28
#define CF_HESDOMAINS		29
#define CF_NISDOMAINS		30
#define CF_LOGREQUESTS		31
#define CF_CHECKFORBINARY	32
#define CF_CTRLLOGDIR		33
#define CF_HOSTDOMAIN		34
#define CF_ARCHITECTURE		35
#define CF_PRINTCAPINCLUDEPATH	36
#define CF_CONFIGINCLUDEPATH	37
#define CF_PERMFILEINCLUDEPATH	38
#define CF_SETUID		39
#define CF_SHOWEMPTYQUEUES	40
#define CF_USEPCAPCACHE		41
#define CF_USEPERMCACHE		42

static struct keyword keywords[] = {
    {"allow-non-priv-ports",	CF_PRIVPORTS},
    {"architecture",		CF_ARCHITECTURE},
    {"check-for-nonprintable",	CF_CHECKFORBINARY},
    {"config-include-path",	CF_CONFIGINCLUDEPATH},
    {"controlfile-log-dir",	CF_CTRLLOGDIR},		/* expanded */
    {"cost-codes-path",		CF_COSTCODES},		/* expanded */
    {"default-printcap-params",	CF_DEFAULTPRINTCAP},
    {"domain-name",		CF_HOSTDOMAIN},
    {"errors",			CF_ERRORSFILE},		/* expanded */
    {"eucs-banner-format",	CF_BANNERFMT},
    {"filter-ld-path",		CF_FILTERLDPATH},	/* expanded */
    {"filter-path",		CF_FILTERPATH},		/* expanded */
    {"forms",			CF_FORMSFILE},		/* expanded */
    {"hesiod-cost-code-key",	CF_HESCOSTCODEKEY},
    {"hesiod-domains",		CF_HESDOMAINS},
    {"hesiod-printcap-key",	CF_HESPCAPKEY},
    {"limits",			CF_LIMITSFILE},		/* expanded */
    {"lockfile",		CF_LPDLOCK},		/* expanded */
    {"log-requests",		CF_LOGREQUESTS},
    {"logfile",			CF_LPDLOG},		/* expanded */
    {"lpd-port",		CF_PRINTERPORT},
    {"mail-format",		CF_MAILFORMAT},
    {"mail-from-address",	CF_FROMADDRESS},
    {"mail-on-error",		CF_MAILONERR},
    {"minfree",			CF_MINFREEFILE},	/* expanded */
    {"nis-cost-code-map",	CF_NISCOSTCODE},
    {"nis-domains",		CF_NISDOMAINS},
    {"nis-printcap-map",	CF_NISPRINTCAP},
    {"printcap-include-path",	CF_PRINTCAPINCLUDEPATH},/* expanded */
    {"printcap-order",		CF_PCAPORDER},
    {"printcap-path",		CF_PRINTCAP},		/* expanded */
    {"printer_perms-include-path", CF_PRINTCAPINCLUDEPATH},/* expanded */
    {"printer_perms-path",	CF_PPERMS},		/* expanded */
    {"restrict-symlinks",	CF_RESTRICTSYMLINKS},
    {"sendmail",		CF_SENDMAIL},		/* expanded */
    {"setuid",			CF_SETUID},
    {"show-empty-queues",	CF_SHOWEMPTYQUEUES},
    {"user",			CF_USER},
    {"use-printcap-cache",	CF_USEPCAPCACHE},
    {"use-perms-cache",		CF_USEPERMCACHE},
    {"zoptions-path",		CF_ZOPTIONS},		/* expanded */
    {"",			CF_UNKNOWN}
};
