#include "lp.h"
#include "library/errormsg.h"
#include "common/mailaddr.h"

void
Make_mail_address (char *to, char *from, char *user, char *host) {
    char *inp, *outp;

    if (Debug > 6)
	log (XLOG_DEBUG, "expanding %s", from);
    if (host == NULL) {		/* check. */
	log (XLOG_INFO, "don't have host!");
	return;
    }
    if (user == NULL) {		/* check. */
	log (XLOG_INFO, "don't have user!");
	return;
    }
    inp = from;
    outp = to;
    while (*inp) {
	switch (*inp) {
	case '%':
	    inp++;
	    switch (*inp) {
	    case 'h':
		(void) strcpy (outp, host);
		outp += strlen (outp);
		break;
	    case 'H':
		(void) strcpy (outp, host);
		outp += strlen (outp);
		break;
	    case 'u':
		(void) strcpy (outp, user);
		outp += strlen (outp);
		break;
	    default:
		*(outp++) = '%';
		*(outp++) = *(inp++);
	    }
	    inp++;
	default:
	    *(outp++) = *(inp++);
	}
	if ((outp - to) > MAXPATHLEN) {
	    fatal (XLOG_INFO, "expanded version of '%s' is too long!", to);
	}
    }
    *outp = '\0';
    if (Debug > 6)
	log (XLOG_DEBUG, "expanded to %s", to);
}
