#!/bin/sh

FILES="
	/usr/bin/lp
	/usr/bin/lpstat

	/usr/ucb/lpr
	/usr/ucb/lprm
	/usr/ucb/lpq

	/usr/ucb/lpc
	/usr/etc/lpc
	/usr/sbin/lpc

	/usr/lib/lpd
	/usr/sbin/lpd
"

if [ $# = 0 ] ; then
    echo "usage: $0 backup-file-suffix"
    exit 1
fi

suffix=$1

rm -f $FILES	> /dev/null 2>&1
tar xpvf bins.lpr.${suffix}

ls -lg $FILES > /tmp/perms$$
diff perms.lpr.${suffix} /tmp/perms$$

stat=$?
rm -f /tmp/perms$$

if [ $stat != 0 ] ; then
	echo "WARNING: restored LPR is not the same as it should be"
fi
exit $stat
