.TH FCONVERT 1
.SH NAME
.I fconvert
\- file to file converter
.SH SYNOPSIS
.B
fconvert
[-i in_file] [-I in_format] [-o out_file] -O out_format
[-c configfile] [-s] [-u] 
.SH DESCRIPTION
.I Fconvert
converts a file of one format to a file of another format.
It maintains a configuration table which contains all of the ways
it knows how to get from one type to another.
.SH GENERAL
.I fconvert 
\- without anything else on the command line will prints the usage and
some of the input and output file types.
The format of the input can be either given in the command line, or if it 
is not given, the program will try to identify it automatically using
the file/fident program. 
The format of the output file will be taken from the -O option, but
if it is not there it will examine the filename and use the part after
the last ".", ie.. filename.gif would be a gif file.  If no output format
is given and the output is stdout, the program will exit with an error message.

The default order in which the configuration files are read is:
.IP 1.  
Any configuration files specified with the -c option, in the order in which they are given.
.IP 2.  
The system's configuration file -- unless turned off with -s option.
.IP 3.  
The users .fconvert file in their home directory -- unless turned off with the -u option.
.SH OPTIONS
.IP \-c filename   
Will specify a filename to use as a configuration file.
.IP \-s
Don't use the global system configuration file.
.IP \-u
Don't use the users config file in their home directory.

.SH EXAMPLES
For the conversion of DVI file to Posctscript file, 

fconvert -Idvi < file.dvi -O ps file.ps

or

fconvert -i file.dvi -o file.ps

or
 
fconvert < file.dvi -o file.ps

For the conversion of Postscript file to ljet3 file, type

fconvert -i file.ps -O ljet3 > file.ljet3
.SH RESTRICTIONS
The program doesn't work for all the combinations of input formats and output
format. In this case, an error message will be given.
.SH FILES
  /usr/local/lib/fconvert.config   System's global configuration file
  $USER/.fconvert                  Users configuration file

The format of the configuration file is

source (tabs or spaces) destination (tabs or spaces) command

If any of the options have tabs or spaces in them, they need to be enclosed
in quotes.  The input type specified by the user or from file/fident is
checked against a regular expression handler which will allow the * to 
be placed in it for global matching.  Therefor, to match a "dvi filetype" 
file one can enter "dvi*".

When the program tries to find a path though to make the output type, it
doesn't look at any of the entries which contain *'s in them.  This checking 
was originally in the code, but all the *'s made to many things be aliases
and the conversion path wasn't using the ones I wanted.

All file types will be converted to lower case and then the comparisons made.
.SH RETURN VALUES
.IP 0 
Everything went OK
.IP 1 
Couldn't figure what output type is.. Possibly not specified.
.IP 2
R/W error in reading or writing to a file.  ie. input/output file.
.IP 3
Couldn't find a way to convert from input to output type.
.IP 4 
Error in one of the conversion programs.
.IP 5
Internal error.. ie, couldn't load CONFIG file, couldn't run file/fident.
.SH BUGS
The pattern matching is strange.  "dvi*" works to match "dvi whatever",
but "*dvi*" doesn't match "dvi whatever", I'm not sure if it's supposed
to work this way or not...?
.SH SEE also
  dvips(1), dvi2tty(1), pbm(1), gs(1), file(1)
.SH AUTHOR
James Jegers, jimj@cs.uwm.edu
