/*
 * Copyright (C) 1992  Board of Regents of the University of Wisconsin
 * on behalf of the Department of Electrical Engineering and Computer
 * Science, University of Wisconsin-Milwaukee, Milwaukee, WI 53201.
 *
 * No Warranty, expressed or implied, comes with this software.
 * This program is free software for private use by individuals and
 * not-for-profit organizations.  Use of of this software for commercial
 * applications or by commercial entities is prohibited.  You can 
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation and
 * and these conditions; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The programs in this directory were developed by software engineering
 * teams as part of the course "Introduction to Software Engineering"
 * under the supervision of Professor G. Davida.
 *
 *
 * Please send all changes, enhancements, and other comments about this
 * software to
 *
 *     		soft-eng@cs.uwm.edu
 *
 *			or
 *		
 *		Software Engineering Coordinator
 *		Computer Science
 *   		Department of EECS
 *		University of Wisconsin - Milwaukee
 *		Milwaukee, WI  53201
 *		414-229-4677
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "config.h"
#include "infostruct.h"

extern struct filedatastruct   filedata;
extern struct convertdatastruct convertdata[];

int convert()
{
    int convert_way, spot; 
    char *tmpstring;

/*  Loop though doing all the conversion, for however many
 *  Are in the list which we have */

    for (spot = 0; filedata.convert_list[spot] != 0; spot++) {
	convert_way = filedata.convert_list[spot];

#ifdef DEBUG
	    fprintf(stderr, "Running %s --> %s == %s\n",
					 convertdata[convert_way].source,
   					 convertdata[convert_way].destination, 
					 convertdata[convert_way].command);
#endif

	if ( convertdata[convert_way].command == NULL)
	    continue;

/*  Make a tempory output file */
	
        tmpstring = tmpnam(NULL);
        filedata.out_file = (char *) malloc( strlen(tmpstring) + 5);
        strcpy(filedata.out_file, tmpstring);

        if (runcommand( convertdata[convert_way].command ) == FALSE) {
	      unlink(filedata.in_file);
	      unlink(filedata.out_file);
	      return(FALSE);
        }
/*  Make the output file now the input file for the next step */

       unlink(filedata.in_file);
       filedata.in_file = filedata.out_file;
    }
    return(TRUE);
}

runcommand(command)
char *command;
{
    char cmd[200];

    strcpy(cmd, command);		/*  Copy the command to execute     */
    strcat(cmd, " ");

    if ( strstr( cmd, INTOK) == NULL) { /*  If don't find $IN use stdin     */
        strcat(cmd, " < ");
        strcat(cmd, filedata.in_file);	
    } else {
	replace(cmd, INTOK, filedata.in_file);
    }

    if (strstr( cmd, OUTTOK) == NULL) { /*  If no $OUT use stdout  	    */
        strcat(cmd, " > ");		/*  stdout to it		    */
        strcat(cmd, filedata.out_file);
    } else {
       replace(cmd, OUTTOK, filedata.out_file);
    }

    if (debug)
	 fprintf(stderr, "running %s\n", cmd);
    
    if ( system(cmd) ) {		/*  Run the command 		     */
         fprintf(stderr, "%s failed\n", cmd);
	 perror("");
	 return(FALSE);
    }
				   
    return(TRUE);
}

