#define AD_MAJOR 24
#define BASE 0x1A0 /* You should set it to the right value */
#define CFG1 BASE + 0x00
#define CFG2 BASE + 0x02
#define CFG3 BASE + 0x04
#define CFG4 BASE + 0x14
#define CNTRCMD BASE + 0x1E
#define DMACLR1 BASE + 0x0C
#define DMACLR2 BASE + 0x0E
#define CNTINTCLR BASE + 0x0A
#define STAT BASE + 0x00
#define PORTA BASE + 0x06
#define PORTB BASE + 0x07
#define PORTC BASE + 0x08
#define PORTD BASE + 0x09

#define CONFIG1 0x0620 /* PORTA PORTB HANDSHAKE enabled
*DBLBuffered PORTA*/
#define CONFIG2 0x0600 /* PORTC and PORTD Handshake enabeld */

#define CONFIG3 0xC800 /*Port C D als output A und B als input
*DBLbuffered PORTB */

#define DRDY_INPUT 0x0100
#define DRDY_OUTPUT 0x0004

#define MAX_ATTEMPTS 1000
#define TIME_OUT 70
#include <linux/fs.h>
#include <linux/errno.h>
#include <linux/mouse.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/major.h>
#include <asm/io.h>
#include <asm/segment.h>
unsigned long ad_board_init(unsigned long);
static int read_ad(struct inode * , struct file * , char * , int );
static int write_ad(struct inode * , struct file * , char * , int );
static int open_ad(struct inode *, struct file * );
void close_ad(struct inode *, struct file * );
int ad_word_polled_read(unsigned short *);
int ad_word_polled_write(unsigned short);

static int nDeviceOpen=0;

int ad_word_polled_read(unsigned short *uValue)
{
 int kl=0;
  while(!(inw(STAT) & DRDY_INPUT)&& kl<MAX_ATTEMPTS)
	 {
		kl++;
	 }
  if(kl>=MAX_ATTEMPTS)
    {
      return(TIME_OUT);
    }
  *uValue=inw(PORTA);
  return(0);
}
int ad_word_polled_write(unsigned short uCommand)
{
int kl=0;
  while(!(inw(STAT) & DRDY_OUTPUT)&& kl<MAX_ATTEMPTS)
	 {
		kl++;
	 }
  if(kl>=MAX_ATTEMPTS)
	 {
		return(TIME_OUT);
	 }
  outw(uCommand,PORTC);
  return(0);
}
struct file_operations ad_board_fops = {
        NULL,           /* ad_seek */
        read_ad,
        write_ad,
        NULL,           /* ad_readdir */
        NULL,           /* ad_select */
        NULL,           /* ad_ioctl */
        NULL,           /* ad_mmap */
        open_ad,
        close_ad,
      };


unsigned long ad_board_init(unsigned long mem_start)
{
  if (register_chrdev(AD_MAJOR,"adc",&ad_board_fops))
                printk("unable to get major %d for ad devices\n",
                       AD_MAJOR);
  printk("Bernd AD\n");
        return mem_start;
}
static int read_ad(struct inode * inode, struct file * file, char * buffer, 
int count)
{
  unsigned short u1;
 char *temp=buffer;
 int retval;
 int read=0;
 
 temp=buffer;
 while(count >0)
   {
     retval=ad_word_polled_read(&u1);
     if(retval==0)
       {
	 put_fs_word(u1,temp);
	 count-=2;
         read+=2;
	 temp+=2;
       }
     else
       {
	 printk("timeout in read\n");
	 count=0;
       }
   }
 return read-count;
}
static int write_ad(struct inode * inode, struct file * file, char * buffer, 
int count)
{
 unsigned short u1;
 char *temp=buffer;
 int retval; 

 temp=buffer;
 while(count >0)
   {
     u1=get_fs_word(temp);
     retval=ad_word_polled_write(u1);
     if(retval==0)
       {
	 count-=2;
	 temp+=2;
       }
     else
       {
	 printk("timeout in write\n");
	 count=0;
       }
   }
 return temp-buffer;
}
static int open_ad(struct inode * inode, struct file * file)
{
 if(nDeviceOpen!=0)
   {
     return(-EBUSY);
   }
 outw_p(0x0100,CFG1);
 outw_p(0x0100,CFG2);
 outw_p(0x0000,CFG3);
 outw_p(0x0000,CFG1);
 outw_p(0x0000,CFG2);
 outw_p(0x0001,CFG4);/*Revision C or later */
 outb_p (0x14,CNTRCMD);/* Counter cleared*/
 outb_p (0x54,CNTRCMD);/*counter cleared*/
 outw_p(0x0000,DMACLR1);/*DMA cleared*/
 outw_p(0x0000,DMACLR2);/*DMA cleared*/
 outw_p(0x0000,CNTINTCLR);/*interupt cleared and disabled*/
 outw_p(CONFIG1,CFG1);
 outw_p(CONFIG2,CFG2);
 outw_p(CONFIG3,CFG3); 
 printk("\nsuccesful opened\n");
 nDeviceOpen=1;
 return(0);
}
void  close_ad(struct inode * inode, struct file *file)
{
  printk("\nsucessful closed ");
  nDeviceOpen=0;
}















