/*
 * Global definitions
 *
 * Copywrite 1993, Hamish Coleman
 */

#include <stdio.h>
#include <sys/types.h>
#include <linux/vm86.h>
#include "dostype.h"

#ifndef TRUE
#define TRUE		(1)
#define FALSE		(0)
#endif

#define _regs	vm86s.regs

#define SEG_ADR(type, seg, reg) type((int)(*(us *)&_regs.seg<<4)\
				 + *(us *)&_regs.e##reg)
#define LO(reg)		(int)(*(unsigned char *)&_regs.e##reg)
#define HI(reg)		(int)(*((unsigned char *)&_regs.e##reg +1))
#define CF 0x01
#define ZF 0x40
#define SF 0x80
#define TF 0x100
#define IF 0x200
#define RF 0x10000

#define CONFIGURATION 0x002c;   /* without disk information */
#define CO	80
#define LI	25
#define SCREEN_ADR(s)	(us *)(0xb8000 + s * 0x1000)
#define UPDATE	250000		/* waiting time in usec */
#define UTICKS	(1250 /* ms */ * CLK_TCK / 1000) /* time betwenn two screen updates in ticks */
#define OUTBUFSIZE	2500
#define CHOUT(c)	if (outp == &outbuf[OUTBUFSIZE]) { CHFLUSH } \
				*outp++ = (c);
#define CHFLUSH		if (outp > outbuf) { write(1, outbuf, outp - outbuf); \
						outp = outbuf; }
#define SETIVEC(i, seg, ofs)	((us *)0)[ (i<<1) +1] = (us)seg; \
				((us *)0)[  i<<1    ] = (us)ofs
#define GETIVEC(i, seg, ofs)	(us)seg = ((us *)0)[ (i<<1) +1]; \
				(us)ofs = ((us *)0)[  i<<1    ]

#define DISKS 2    /* maximum 4 */
#define HDISKS 2	/* maximum 2 */
extern int hdiskboot;

extern int screen;
extern int screen_bitfield;
extern struct vm86_struct vm86s;

void show_regs(void);
void dump_hex(u_char *buf, long len);
int i386dis(int mode, int cs, int ip, u_char *inbuf, char *outbuf);
void clear_screen(int s, int att);
void restore_screen(int bitmap);
void char_out(unsigned char ch, char attr, int s);

extern char * emu_banner;

/*
 * Change this here if you want to log to a different place
 */

extern FILE * fdeb;
#define DEBUGFILE "/dev/tty8"

#ifdef DEBUG
#define debmsg(f,a...)		fprintf(fdeb,f,##a)
#else
#define debmsg(f,a...)		/* */
#endif
