#ifndef _LIST_H
#define _LIST_H

/*****************************************************************************
 *
 *	module:		list.h
 *	author:		Marc van Kempen
 *	desc:		include file for list
 *
 *****************************************************************************/


/*****************************************************************************
 *
 *	defines
 *
 *****************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <sys/ioctl.h>
#include <stdlib.h>

#ifndef TRUE		/* not all stdlib's have this */
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif

#ifndef min
#define min(a,b)	(a) < (b) ? (a) : (b)
#endif
#ifndef max
#define max(a,b)	(a) > (b) ? (a) : (b)
#endif


/* keyvalues from getkey() */

#define ESC             27
#define BS              8
#define UPARROW		300
#define DNARROW		301
#define RIGHTARROW	302
#define LEFTARROW	303
#define PGDN		304
#define PGUP		305
#define HOME		306
#define END		307
#define DEL		308
#define INS		309

/* define this to suit your taste, vi-like cursorkeys, or mine */


#define KEYUP           'i'
#define KEYDOWN         'm'
#define KEYRIGHT        'k'
#define KEYLEFT         'j'


/* vi-like cursorkeys */
/*
#define KEYUP           'k'
#define KEYDOWN         'j'
#define KEYRIGHT        'l'
#define KEYLEFT         'h'
*/   

/* Filetype values */

#define ZIPFILE		1
#define BINARYFILE	2
#define TEXTFILE	3
#define GIFFILE		4
#define PSFILE		5
#define GZIPFILE	6
#define TARFILE		7

/* miscellaneous definitions */
#define MAXTARFILES	500		

#define MAXZIPFILES 	500		/* max. nr of files per ziparchive */
#define COLWIDTH        40		/* width of the columns in list */
#define TMPFILE		tmpnam(NULL)	/* file for temporary results */

/*****************************************************************************
 *
 *	typedefs
 *
 *****************************************************************************/

typedef struct DirList {			/* structure to hold the directory entries */
	char		filename[MAXNAMLEN];	/* together with the stat-info per file */
	struct stat	filestatus;		/* filename, or the name to which it points */
	int		link;			/* is it a link ? */
	char		*linkname;		/* the name of the file the link points to */
} DirList;
	

/*****************************************************************************
 *
 *	prototypes
 *
 *****************************************************************************/


void catch_resize_signal(void);
int  get_filetype(char *fname);
int  new_path(DirList **dir, int *ndirs, int screeny);
void make_file(void);
void exec_usercmd(void);
void display_help(void);
int  copy_file(char *fname);
int  delete_file(DirList d);
void edit_file(char *fname);
int  process_file(DirList **dir, int *ndirs, int i);
void display_list(DirList *dir, int ndirs, int bl, int el, 
		int screenx, int screeny);
void choose_list(DirList *dir, int ndirs);

void view_file(char *fname);
void view_textfile(char *fname);
void view_zipfile(char *fname);
void view_gzipfile(char *fname);
void view_binaryfile(char *fname);
void view_giffile(char *fname);
void view_postscriptfile(char *fname);
void view_tarfile(char *fname);

int  is_tar();

void get_screensize(struct winsize *w);
void get_dir(char *dirname, DirList **dir, int *n);
void display_dir(char *dir, int n);
int  search_dir(char *dirname, DirList *dir, int ndirs);

int  getkey(void);

/* sort functions */
int  dir_alphasort(const void *d1, const void *d2);
int  dir_sizesort(const void *d1, const void *d2);
int  dir_datesort(const void *d1, const void *d2);
int  dir_extsort(const void *d1, const void *d2);

#endif /* _LIST_H */
