/* 'Automatic'? UN*X to DOS / OS/2 text format conversions, i.e either putting
 * in or removing CRs, turning LF to CRLF when writing to a UNiX file, and
 * removing the CRs when writing to a DOS file.
 * Copyright (C) 1995 Liam.C.Drew.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Written by L.C.Drew, 91069690@BROOKES.AC.UK or LCD@SA750.RL.AC.UK
 * Snail : L.C.Drew, 11 Cley Hall Drive, Spalding, Lincs, PE11 2DZ, England.
 */

/* define MULTI if you want u2d to make sure the file name is unique, when using
 * a multi-tasking system, so that 2 u2ds running at the same time won't interfere
 * with each other, don't define it when compiling under DOS.
 */ 
#define MULTI

#include <stdio.h>
 
/* Change this line to define where your temp file should go. 
 */
char *tempfile="/tmp/u2d.temp.file";

 
FILE *infile, *outfile;

int convert(void);

int convert(void){
	char ch;
	
	while((ch = getc(infile)) != EOF){
		if(ch == 0x0A){
			fputc(0x0D, outfile);
			fputc(ch, outfile);
		} else if (ch == 0x0D){
			if((ch = fgetc(infile)) != 0x0A){
				return(0);
			}
			fputc(ch, outfile);
		} else (fputc(ch, outfile));
	}
	return(1);
};

int main(int argc, char *argv[]){
	int count, moving = 0;
	char newfilename[128];

	if ((!strcmp(argv[1], "-c"))||(!strcmp(argv[1], "-m"))){
		if (argc%2){
			fprintf(stderr, "If you are copying/ moving files, you must specify an even number of filenames!\n");
			exit(1);
		}
		if (!strcmp(argv[1], "-m")) moving = 1;
		count = 2;
		while (count < argc){
			if(!(infile = fopen(argv[count++], "r"))){
				fprintf(stderr,"(1)Error opening the input file %s.\n", argv[count-1]);
			} else if(!(outfile = fopen(argv[count++], "w"))){
				fprintf(stderr,"(1)Error opening the output file %s.\n", argv[count-1]);
				fclose(infile);
			} else {
				if (!(convert())){
					fprintf(stderr,"(1)Error converting file %s.\n", argv[count-2]);
					fclose(infile);
					fclose(outfile);
				} else {
					fclose(infile);
					fclose(outfile);
					if (moving) unlink(argv[count-2]);
				}
			}
		}
		exit(0);
	} 	
	if ((argc == 1) || (!strcmp(argv[1], "-h"))){
		fprintf(stderr, "u2d, DOS to UNIX (& back) text file converter (c)Liam.C.Drew 1995 Ver.1.\n");
		fprintf(stderr, "To convert a file, enter 'u2d filename...', this will replace the files in the\n");
		fprintf(stderr, "list with files converted to the other type.\n");
		fprintf(stderr, "SWITCHES : (only one may be used, and it must be the first argument)\n");
		fprintf(stderr, "      -c : copy and convert, filenames must be in pairs, e.g. :\n");
		fprintf(stderr, "                    'u2d -c text.unix /tmp/text.dos'\n");
		fprintf(stderr, "           overwrites '/tmp/text.dos' with a converted 'text.unix'\n");
		fprintf(stderr, "      -m : move and convert, filenames must be in pairs, e.g. :\n");
		fprintf(stderr, "                    'u2d -m text.unix /tmp/text.dos'\n");
		fprintf(stderr, "           overwrites '/tmp/text.dos' with a converted 'text.unix', and\n");
		fprintf(stderr, "           deletes 'text.unix'.\n");
		fprintf(stderr, "      -s : get filenames to convert from stdin, e.g. :\n");
		fprintf(stderr, "                    'ls text.* | u2d -s'\n");
		fprintf(stderr, "           converts 'text.*' in the current directory\n");
		fprintf(stderr, "\nWildcards may only be used when converting files, i.e not with '-c' or '-m'.\n");
		exit(0);
	} else if(!strcmp(argv[1], "-s")) {
#ifdef MULTI
		tempfile = tempnam(0,0);
#endif
		while(fscanf(stdin, "%s", newfilename) != EOF){
			if(!(infile = fopen(newfilename, "r"))){
				fprintf(stderr,"(2)Error opening the input file %s.\n", newfilename);
			} else if(!(outfile = fopen(tempfile, "w"))){
				fprintf(stderr,"(2)Error opening the output file %s.\n", tempfile);
				fclose(infile);
			} else {
				if (!(convert())){
					fprintf(stderr,"(2)Error converting file %s.\n", newfilename);
					fclose(infile);
					fclose(outfile);
				} else {
					fclose(infile);
					fclose(outfile);
					rename(tempfile, newfilename);
				}
			}
		}
		unlink(tempfile);
	} else {
#ifdef MULTI
		tempfile = tempnam(0,0);
#endif
		count = 1;
		while(count < argc) {
			if(!(infile = fopen(argv[count++], "r"))){
				fprintf(stderr,"(3)Error opening the input file %s.\n", argv[count-1]);
			} else if(!(outfile = fopen(tempfile, "w"))){
				fprintf(stderr,"(3)Error opening the output file %s.\n", tempfile);
				fclose(infile);
			} else {
				if (!(convert())){
					fprintf(stderr,"(3)Error converting file %s.\n", argv [count-1]);
					fclose(infile);
					fclose(outfile);
				} else {
					fclose(infile);
					fclose(outfile);
					rename(tempfile, argv[count-1]);
				}
			}
		}
		unlink(tempfile);
	}
	fclose(infile);
	fclose(outfile);
	return(0);
}
