#ifndef _EXTERN_H
#define _EXTERN_H

#ifdef linux
#include <termcap.h>
#else
unsigned short ospeed;
#endif

#define TERMCAP_BUFSIZE	2048	/* 2048 for GNU Termcap */

extern char PC;
extern struct termios mode, oldmode;
extern int columns, isreset, lines;
extern int erasechar, intrchar, killchar;
extern int ocolumns, olines, dosetwin;

#define _CTRL(c)        (c&037)

#ifndef CINTR
#define CINTR   _CTRL('c')
#define CQUIT   034             /* FS, ^\ */
#define CERASE  0177            /* DEL, ^? */
#define CKILL   _CTRL('u')
#define CEOF    _CTRL('d')
#define CEOT    CEOF
#define CEOL    0
#define CEOL2   0
#define CSWTCH  0
#define CNSWTCH 0
#define CSTART  _CTRL('q')
#define CSTOP   _CTRL('s')
#define CSUSP   _CTRL('z')
#define CDSUSP  _CTRL('y')
#define CRPRNT  _CTRL('r')
#define CFLUSH  _CTRL('o')
#define CWERASE _CTRL('w')
#define CLNEXT  _CTRL('v')
#endif  /* !CINTR */
   
#endif /* _EXTERN_H */
