#ifndef lint
static char RCSid[] = 
"$Id: tty.c,v 6.1 1993/03/25 21:06:01 mcooper Exp mcooper $";

static char copyright[] =
"@(#) Copyright (c) 1990-1993 Michael A. Cooper.\n\
 All rights reserved.\n";
#endif

/*
 * Copyright (c) 1990-1993 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

/*
 * Terminal interface routines
 */

#include "config.h"
#include "qterm.h"
#include <stdio.h>

#if	!defined(STDIN_FILENO)
#define STDIN_FILENO		0
#endif

#if	TTY_TYPE == TTY_POSIX
/*
 * POSIX set terminal modes function
 */
struct termios			OrigTty;

int SetTtyModes()
{
    struct termios		newtty;

    if (tcgetattr(STDIN_FILENO, &OrigTty) != 0) {
	Error("Cannot get tty modes: %s.", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    newtty = OrigTty;
    newtty.c_iflag &= ~(INLCR|IGNCR);	/* ignore CR */
    newtty.c_lflag &= ~(ECHO);		/* noecho */
    newtty.c_lflag &= ~(ICANON);	/* crmode */
    newtty.c_cc[VMIN] = 1;		/* crmode */
    newtty.c_cc[VTIME] = 0;		/* crmode */

    if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &newtty) != 0) {
	Error("Cannot set tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif	/* TTY_SYSV */

#if	TTY_TYPE == TTY_SYSV
/*
 * System V set terminal modes function
 */
struct termio			OrigTty;

int SetTtyModes()
{
    struct termio		newtty;

    if (ioctl(STDIN_FILENO, TCGETA, &OrigTty) < 0) {
	Error("Cannot get tty modes: %s.", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    newtty = OrigTty;
    newtty.c_iflag &= ~(INLCR|IGNCR);	/* ignore CR */
    newtty.c_lflag &= ~ECHO;		/* noecho */
    newtty.c_lflag &= ~ICANON;		/* crmode */
    newtty.c_cc[VMIN] = 1;		/* crmode */
    newtty.c_cc[VTIME] = 0;		/* crmode */

    if (ioctl(STDIN_FILENO, TCSETAF, &newtty) < 0) {
	Error("Cannot set tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif	/* TTY_SYSV */

#if	TTY_TYPE == TTY_BSD
/*
 * BSD set terminal modes function
 */
struct sgttyb			OrigTty;

int SetTtyModes()
{
    struct sgttyb		newtty;

    if (ioctl(STDIN_FILENO, TIOCGETP, &OrigTty) < 0) {
	Error("Cannot get tty modes: %s.", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    newtty = OrigTty;
    newtty.sg_flags |= CBREAK;		/* crmode */
    newtty.sg_flags &= ~ECHO;		/* noecho */

    if (ioctl(STDIN_FILENO, TIOCSETP, &newtty) < 0) {
	Error("Cannot set tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif	/* TTY_BSD */

#if	TTY_TYPE == TTY_POSIX
/*
 * POSIX restore terminal modes
 */
int UnSetTtyModes()
{
    if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &OrigTty) != 0) {
	Error("Cannot restore tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif	/* TTY_POSIX */

#if	TTY_TYPE == TTY_SYSV
/*
 * System V restore terminal modes
 */
int UnSetTtyModes()
{
    if (ioctl(STDIN_FILENO, TCSETAF, &OrigTty) < 0) {
	Error("Cannot restore tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif	/* TTY_SYSV */

#if	TTY_TYPE == TTY_BSD
/*
 * BSD restore terminal modes
 */
int UnSetTtyModes()
{
    if (ioctl(STDIN_FILENO, TIOCSETP, &OrigTty) < 0) {
	Error("Cannot restore tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif	/* TTY_BSD */
