
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

#ifndef _agent_h
#define _agent_h

#include <fstream.h>
#include "myString.h"
#include "enum.h"
#include "line_link.h"

static const int META_CHAR = '\034';

class agent_line_link {
   friend class agent_link;
   friend class agent;
   friend class screen;
   agent_line_link();
   agent_line_link(agent_line_link&);
   mode line_md;
   string* line;
   /*cond test;*/
   string* sample;
   void empty();
   agent_line_link* next;
   agent_line_link* parent;
   agent_line_link* alt_branch;
};

class agent_link {
   friend class agent;
   friend class screen;
   agent_link();
   string* name;
   agent_line_link* body;
   string* context[MAX_CONTEXTS];
   agent_link* next;
   void empty();
};

class agent {
   friend class screen;
   agent();
   ~agent();
   agent_link* actions;
   void insert_action(string*, line_link*, line_link*);
   void insert_alt_action(agent_line_link*, line_link*, line_link*);
   void save_branch(agent_line_link*, ofstream&, short);
   void save_actions();
   void init_branch(agent_line_link*, ifstream&, short, agent_line_link*);
   void init_actions();
   void delete_actions();
};

#endif /*!_agent_h*/
