#include <sys/types.h>

#define HOME_DIR_LEN     45
#define GRUNGED_FILE_LEN 31
#define DEL_LOG_LEN      49
#define FILE_NAME_LEN    256
#define WORK_BUF_LEN     512
#define SAFE_DIR_LEN     256
#define SAFE_RC_LEN      256

#define PREFIX   1
#define SUFFIX   2
#define INFIX    3
#define FULLNAME 4
#define ALLFILES 5

#define VERSION 11

/* file_struct.FileFlag values */

#define NOCOMPRESS 1     /* Safedeleted copy not compressed */

/* Original file information */

typedef struct
{
int     Version;
int     FileFlag;
umode_t Mode;
uid_t   Uid;
gid_t   Gid;
off_t   Size;
time_t  Atime;
time_t  Mtime;
} file_struct;

/* .Safedelrc structures */

typedef struct
{
char *FileName;
int  Type;
int  PreLen;
int  SufLen;
int  Days;
} safedays_struct;

typedef struct
{
char *FileName;
int  Type;
int  PreLen;
int  SufLen;
char *CompCmd;
char *UncompCmd;
} compression_struct;

typedef struct
{
char *CmdName;
char *Suffix;
} suffix_struct;

typedef struct
{
int  NumDaysEnts;
safedays_struct *DaysStruct;
int  NumCompressEnts;
compression_struct *CompStruct;
int  NumSuffixes;
suffix_struct *SuffStruct;
} rcstruct;

/* Global external subroutine prototypes */

extern int ParseFileName(char *FileName);
extern int CheckPerms(char *DirName, char *FileName, char *Cmd);
extern rcstruct *ReadRC(char *RCFileName, char *SectName);
extern int CheckFilePattern(char *FileName, compression_struct *cs);
extern int CheckFileDays(char *FileName, safedays_struct *ss);
