#include <stdio.h> 
#include <dirent.h>  

/*************************************************************************/

typedef struct _DirNode {
	char *name;		/* dir name */
	char *lname;	/* NULL, or link name */
	int x, y;	/* x,y position origin = (0,0) */
	struct _DirNode *left, *right, *up, *down;	/* other node ptrs */
} DirNode;

/*************************************************************************/

#ifndef GLOBAL_DEF

extern int _rebuild;
extern int _scope;
extern int _rebauto;
extern int _verbose;
extern int _justdump;
extern int _lineart;
extern int _showlink;

/*************************************************************************/
/* other global variables */

extern char _home[PATH_MAX];
extern char _xhome[PATH_MAX];
extern char _cwd[PATH_MAX];
extern char _root[PATH_MAX];
extern char _xroot[PATH_MAX];
extern char _finalDir[PATH_MAX];
extern char _argumentDir[PATH_MAX];

extern char _homeFile[PATH_MAX];
extern char _fullFile[PATH_MAX];
extern char _selDirFile[PATH_MAX];

extern DirNode *_rootNode;
extern DirNode *_lastNode;
extern int _nLinks;  

extern char _searchPath[PATH_MAX];
extern int _searchPLen;
extern int _searchPX;

extern int _x0;
extern int _y0;
extern DirNode *_curNode;

extern int _cols;
extern int _lines;
extern int _use_color;
extern int _cursesOn;

int _refCurrent;
int _refRest;
int _refCurDir;
int _refSearch;

#endif

/*************************************************************************/
/* special codes to format directory tree. Arbitrary way selected */

#define __ACS_HL 1          /* line art codes */
#define __ACS_VL 2
#define __ACS_LT 3
#define __ACS_LLC 4
#define __ACS_TT 5

#define __SEL_ON 6           /* selection on/off codes */
#define __SEL_OFF 7


/* other constants */
#define MAX_LINKS   256   /* if more recursive links, error */
#define SEARCHWIN_LEN 30   /* max visible length for search window */
#define MIN_LINES 6        /* min. LINES in screen  */
#define MIN_COLS 30        /* min. COLS in screen */
#define HLP_LINES 14	/* lines used for help screen */
#define HLP_COLS 60     /* columns used for help screen */
 
/*************************************************************************/
/* prototipes for dirs.c */

char *addSlash(char *dirName);
char *stripSlash(char *dirName);
char *compactAbsDir(char *absDirName);
char *trueDir(char *dir);
char *getDirName(char *dirPath);

/*************************************************************************/
/* prototipes for nodes.c */

DirNode *readDirsInNodes(char *baseName, DirNode * baseNode);
DirNode *readNodesFromFile(char *fname);
void writeSubNodeTreeToFile(FILE * f, DirNode * node);
void writeNodesToFile(char *fname, DirNode * baseNode);
void delNodesFromMemory(DirNode * baseNode);
char *getNodeName(DirNode * node, int showlink);
char *getNodeFullPath(DirNode * node, int withlink, int relative, DirNode * relNode, int use_xroot);
int numerateNodeTree(DirNode * rootNode, int x, int y);
DirNode *getNodeFollowLink(DirNode * rootNode, DirNode * node);
char *getTreeLine(DirNode * node, int lineart, int marksel);

/*************************************************************************/
/* prototipes for nodeops.c */

DirNode *searchNodeForDir(DirNode * baseNode, char *baseDir, char *dir);
DirNode *getLastDescendant(DirNode * node);
DirNode *getLastNodeInSameLevel(DirNode * node);
DirNode *getFirstNodeInSameLevel(DirNode * node);
DirNode *getAnyNodeInLevel(DirNode * node, int level);
DirNode *getLastNodeInLevel(DirNode * node, int level);
DirNode *getFirstNodeInLevel(DirNode * node, int level);
DirNode *getNodeCursUp(DirNode * curNode);
DirNode *getNodeLnUp(DirNode * curNode);
DirNode *getNodeLnDn(DirNode * curNode);
DirNode *getNodePrev(DirNode * curNode);
DirNode *getNodeCursDown(DirNode * curNode);
DirNode *getNodeCursLeft(DirNode * curNode);
DirNode *getNodeCursRight(DirNode * curNode);
DirNode *locatePathOrSo( char * path, char * *rest );
DirNode *nextNodeCiclic(DirNode * rootNode, DirNode * curNode);
int validSearchDir( char * fullDir, char * fullDirLink, char * searchDir );
DirNode *findDirInCicle(DirNode * rootNode, DirNode * curNode, char *dir);
DirNode *findDirSegInCicle(DirNode * rootNode, DirNode * curNode, char *dir);
DirNode *directSelectANode( void );
void showTree(DirNode * rootNode);

/*************************************************************************/
/* prototipes for curs.c */

void ioInitialize(void);
void ioTerminate(void);
void prepareColorModes(void);
int getColorMode(int c);
int getKey(int delay);
int kbHit(void);
void showHelp();
DirNode * selectANode( int * quit );

/*************************************************************************/
/* prototipes for disp.c */

void paintLayout(void);
char *truncString(char *s, int maxlen);
void updateLine(int i);
void dataRefresh(int newx, int newy, DirNode * newNode);
void editSearch(int ch);
void showHelpScreen();
void showHelpNoSpace();
void cursRebuildMsg();

/************************************************************************ */
/* prototipes for ncd.c */

void cleanUp( void );
int parseOpts(int argc, char *argv[]);
int parseArguments(int argc, char *argv[]);
DirNode *rebuildTree(void);
DirNode *readTreeFiles(void);
int getFinalPath( DirNode * node );
void initializeFinalDir( void );
void changeToFinalDir( void );
void getGlobals( int init_cwd );

/*************************************************************************/
