/*
 * locatedir.h
 *
 * This file is part of "locatedir"
 * by Alexander Kourakos <awk@vt.edu>
 *
 * Copyright (C) 1994 Alexander Kourakos
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice remains unchanged on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the author.
 *
 * There is no warranty or other guarantee of this software fitness
 * for any purpose. It is provided solely "as is".
 */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#define VERSION                 "0.1.3"

/*
 * The name of the directory list file, stored in the user's
 * home directory.
 */

#define DIRLIST                 ".dirlist"

/*
 * Maximum number of days before locatedir tries to rebuild the
 * directory list.
 */

#define MAX_DAYS                7

/*
 * Shouldn't have to change these.
 */

#define FIND_COMMAND            "find %s -type d -not -fstype proc"
#define SORT_COMMAND            "sort -if %s"

/*
 * Other stuff.
 */

#define MAX_PATH_LENGTH         512
#define MAX_NAME_LENGTH         32

#define DIR_SEP                 "/"
#define DIR_SEP_CHAR            DIR_SEP[0]

#define HERE                    "."

#define TRUNC_LAST_CHAR(s)      {(s)[strlen(s) - 1] = '\0';}

#define MAX_SECS                (time_t)(MAX_DAYS * 24L * 60L * 60L)

/*
 * Function prototypes.
 */

void    error (const char *);
void    usage (void);

void    mangle (char *);
void    demangle (char *);

FILE   *open_dirlistfile (const char *);
void    build_dirlistfile (const char *);

int     find_best_match (FILE *, const char *, char *);

int     main (int, char **);

/*
 * Global variable declarations.
 */

#ifdef GLOBALS
#define global
#else
#define global extern
#endif

global char progname[MAX_NAME_LENGTH];
global char homepath[MAX_PATH_LENGTH], cwdpath[MAX_PATH_LENGTH];
global char startpath[MAX_PATH_LENGTH];

global int quiet, rebuild_if_old, echo_dots;

/*
 * end of file 
 */
