#include	"def.h"

#include	<ctype.h>
#include	<signal.h>
#include	<string.h>
#include	<time.h>
#include	<pwd.h>

char logfile[MAXLINELENGTH];
FILE* logfd;
char editor[MAXFNAME];
char *pager;
char *defaultEditor = DEFAULTEDITOR;

logcommand(cmd)
char* cmd;
{
    time_t tim;
    char atime[100];
    logfd = fopen(logfile, "a");
    if (logfd) {
	int uid = getuid();
	struct passwd *pw = getpwuid(uid);
	time(&tim);
	strcpy(atime,ctime(&tim)); atime[strlen(atime)-1] = '\0';
	fprintf(logfd, "%s[%s](%s): %s\n", cuserid(NULL), pw->pw_name, atime, cmd);
	fclose(logfd);
    }
}

/*
 * Interrupt handler.  Stop curses and exit gracefully.
 */
void
cleanup_sig (sig,code,scp)
int sig, code;
struct sigcontext *scp;
{
    /* ignore further interrupts */     /*  mhc: 11/2/91 */
    (void) signal (SIGHUP, SIG_IGN);
    (void) signal (SIGINT, SIG_IGN);
    (void) signal (SIGTERM, SIG_IGN);

    if (sig != SIGHUP) {
	logcommand("INTERRUPTED");
	cleanup();
	printf("\nExiting via interrupt: exit(%d)\n",sig);
	fflush(stdout);
    }
    exit(sig);
}

char *checkEnv(var, def)
char *var, *def;
{
	char *val = getenv(var);
	if (val)
		return(val);
	else
		return(def);
}

int main(argc, argv)
int argc;
char *argv[];
{
    int  i;
    char *startfile = STARTFILE;
    char *startdir = STARTDIR;
    char *cp;
    FILE *fp;

    char *ed = getenv("EDITOR");
    strcpy(editor, (ed ? ed : defaultEditor));
    pager = checkEnv("PAGER", DEFAULTPAGER);

    /*
     * Process arguments - with none, look for the database in STARTDIR,
     * starting with STARTFILE.
     *
     * If a pathname is given, use it as the starting point.  Split it
     * into directory and file components, and view the file.
     */
    for (i=1; i<argc; i++) {
	if (strncmp(argv[i], "-s", 2) == 0) {
	    extendSearchPath(&argv[i][2]);
	} else if (strncmp(argv[i], "-", 1) == 0) {
	    printf("Usage: brow [options] [file]\n");
	    printf("Options are:\n");
	    printf("    -s<searchPath>\n");
	    exit(0);
	} else {	/* alternate database path */
	    cp = strrchr(argv[i], '/');
	    if (cp == NULL) {
		startfile = argv[i];
	    } else {
		startdir = argv[i];
		startfile = cp+1;
		*cp = '\0';
		addSearchPath(argv[i]);
	    }
	}
    }
    addSearchPath(STARTDIR);
    initVariables();
    /*
     * make sure we can read the first file
     */
    if ((fp=fopenWithSearchPath(startfile, "r")) == NULL) {
	printf("%s: can't find file: %s/%s\n", argv[0], startdir, startfile);
	exit(0);
    } else
	(void) fclose(fp);

    /*
     * here's where we do all the work
     */
    if (screenInit()) {
	/* trap interrupts */     /*  mhc: 11/2/91 */
	(void) signal (SIGHUP, cleanup_sig);
	(void) signal (SIGINT, cleanup_sig);
	(void) signal (SIGTERM, cleanup_sig);

	strcpy(logfile, STARTDIR); strcat(logfile, "/user_log");
	logcommand("LOGIN");
	mainloop(startfile);
	cleanup();
	logcommand("QUIT");
    }

    exit(0);
}

#ifdef	SETENV
#define	MAXENV	200
#ifdef  NOPROTO
setenv(term, val, overwrite)
char* term; char* val; int overwrite;
#else
setenv(char* term, char* val, int overwrite)
#endif
{
	static int count = 0;
	static char * allocated[MAXENV];

	int j;
	char *p;

	p = getenv(term);
	for (j=0; j<count; j++)
		if (allocated[j] == p-strlen(term)-1) {
			free(allocated[j]);
			goto alloc;
		}
	if (j == MAXENV) {
		prompt("out of internal environment space", 0);
		return;
	}
	count = j;
	alloc:
	allocated[j] = malloc(strlen(term)+strlen(val)+2);
	sprintf(allocated[j], "%s=%s", term, val);
	putenv(allocated[j]);
}

#ifdef  NOPROTO
unsetenv(term)
char* term;
#else
unsetenv(char* term)
#endif
{
	setenv(term, "", 1);
}
#endif
