#include "vgadef.h"
.text
	.globl	_asm_scroll
	.comm	_graph_mem,4
	.align 4

SY =	8
EY = 	12
LINE = 	16
MCOLOR=	20


	
_asm_scroll:	

	pushl	%ebp
	movl	%esp,%ebp
	pushl	%esi
	pushl	%edi
	mov 	%ds,%ax
	mov	%ax,%es

	# calculate the source base
	# Y * 80
	movl	SY(%ebp),%edi		# edi = SY
	movl	EY(%ebp),%ecx		# ecx = EY-SY ie hieght
	subl	%edi,%ecx
	leal	0(%edi,%edi,4),%edi      
	sall	$4,%edi			# edi = SY*80
	# graph_mem[Y*80]
	addl	_graph_mem,%edi         # edi = graph_mem[SY*80]
	movl	LINE(%ebp),%esi         # esi = LINE 
	subl	%esi,%ecx               # ecx = EY-SY-LINE+1
					# i.e. the height of area which
					# must be scroll
	incl	%ecx
	leal	0(%esi,%esi,4),%esi	
	sall	$4,%esi			
	addl	%edi,%esi		# esi = graph_mem[(SY+LINE)*80]
					# i.e. the first position must be copy
	# set to write mode 1
	mov	$GRA_I,%dx
	movw	$0x0105,%ax
	outw	%ax,%dx
	# in this time
	# edi = graph_mem[SY*80]
	# esi = graph_mem[(SY+LINE)*80]
	# ecx = the height of area must be copy
#ifdef VGA_16BIT
	#CX*40
	leal	0(%ecx,%ecx,4),%ecx	# in 16bit mode 40 words must be copy
	sall	$3,%ecx
	rep
	movsw
#else
	# CX*80
	leal	0(%ecx,%ecx,4),%ecx	# in 8bit mode 80 bytes must be copy
	sall	$4,%ecx		

	rep 				
	movsb				
#endif

	# blank the below line
	# use mode 
	movw	$0x0a05,%ax
	outw	%ax,%dx
	movw	$0xff08,%ax
	outw	%ax,%dx
	movw	$7,%ax
	outw	%ax,%dx
	movw	$3,%ax
	outw	%ax,%dx
	movw	MCOLOR(%ebp),%ax
	movb	%ah,%al
	movl	LINE(%ebp),%ecx
#ifdef VGA_16BIT
	leal	0(%ecx,%ecx,4),%ecx
	sall	$3,%ecx
	rep
	stosw
#else
	leal	0(%ecx,%ecx,4),%ecx
	sall	$4,%ecx

	rep 
	stosb
#endif
L1:
	mov	$0x0805,%ax
	outw	%ax,%dx
ed:	pop	%edi
	pop	%esi
	movl	%ebp,%esp
	pop	%ebp
	ret

	
	
	
		
	



