#define CHINESE_KERNEL


/* Copyright(c) 1993
   The below program is used to display chinese character in screen
   without X window in LINUX.The program is protected under GNU copyleft
   .The detailed is as GNU's COPYING which i include it in the package.
   You can distribute this program freely.But YOU MUST DISTRIBUTE THE
   COMPLETE CODE IN THE PACKAGE.If you have modified the package,you
   must note it in README file and told others how to get the origin 
   version.
*/
/*
   ChangeLog
   BuildDate 08/22/1993
       08/28/1993
          (1) Move part of code to ttyserver.c
       09/04/1993
          (1) Version 0.2 start.
	  (2) The virtual screen only interrupt when screen is in
	      graphics mode.
*/
 
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <syslog.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/kd.h>
#include <setjmp.h>
#include <sys/time.h>
#include <errno.h>
#include <sys/vt.h>
#include <termios.h>
#include "chinese.h"
#include "chmsg.h"
#include "vga.h"

#ifdef DEBUG
#define D(p)  (p)
#else
#define D(p)  (p)
#endif


/***********************************************/
/*   Get the control of virtual console from   */
/*   kernel                                    */
/***********************************************/
FILE *stddebug;                         /* output foe debug */
SYSCFG sys_config;
static int lastmode;                          
static struct vt_mode vmode;    /* record console state for restore*/
static int ttyfd;
int infd;                                 /* file descriptor for tty input */
static char cap[CONS_NUM];                /* if cap[con] on, stand for terminal
					     has been managed by chdrv 
					  */

static char buf[262];                     /* common buffer */
static struct winsize ttywinsize;         
static struct termios save_termios; /* termio state for restore */
static int nowconsole;                    /* current activated console */
static int have_screen_control;
static int trig_lock=0,trig_unlock=0;     /* used for delay console change */

/* 
   We just record the occures of console switch,and switch when we return
   to ioloop.This will avoid switch change when draw graphics in screen 
*/
static void unlock_vt(int signo)
{
  trig_unlock = 1;
}
static void lock_vt(int signo)
{
  trig_lock = 1;
}

/*
   The below routine do real work of console switch.
*/
static void _unlock_vt(int signo)
{
  signal(SIGREL,unlock_vt);
  ch_restoretext();
  ioctl(infd,VT_RELDISP,1);
  have_screen_control = 0;
  ch_cursor_blink(0);
  nowconsole = -1;
}

static void _lock_vt(int signo)
{
  unsigned long mode;
  ChineseMessage msg;
  struct vt_stat vstate;
  static int forbid_switch = 0;
  void (*old_alrm)(int);

  if (forbid_switch)
    return;
  forbid_switch = 1;
  signal(SIGALRM,SIG_IGN);
  signal(SIGACQ,lock_vt);
  ioctl(infd,VT_GETSTATE,(int)&vstate);
  nowconsole = vstate.v_active-1;
  ioctl(infd,VT_RELDISP,VT_ACKACQ);
  have_screen_control = 1;
  ch_change_console(nowconsole);
  ch_cursor_blink(1);
  
  forbid_switch = 0;
  
}

static char ttys[] = {"/dev/tty0"};
static void Install_vt_control()
{
  int curcons,mask,fd;
  struct vt_mode mode;
  struct vt_stat stat;
  
  ttyfd = open("/dev/tty",O_WRONLY);
  ioctl(ttyfd,VT_GETSTATE,(int)&stat);
  mask = 2;  
  nowconsole = stat.v_active-1;
  for(curcons = 0;curcons < CONS_NUM;curcons++)
    {
      ttys[8] = curcons+'1';

      if (stat.v_state & mask)
	{
	  fd = open(ttys,O_RDWR|O_NDELAY);
	  ioctl(fd,VT_GETMODE,(int)&vmode);
	  close(fd);
	}
      mask << 1;
    }
  close(ttyfd);
  signal(SIGREL,unlock_vt);
  signal(SIGACQ,lock_vt);
}

void Restore_vt_control()
{
  int curcons,mask,fd;
  struct vt_mode mode;
  struct vt_stat stat;

  ioctl(0,VT_GETSTATE,(int)&stat);
  mask = 2;  
  nowconsole = stat.v_active-1;
  for(curcons = 0;curcons < CONS_NUM;curcons++)
    {
      if (stat.v_state & mask)
	{
	  tcsetattr(infd,TCSAFLUSH,&save_termios);
	  ioctl(infd,VT_SETMODE,(int)&vmode);
	  ioctl(infd,KDSETMODE,KD_TEXT);
	}
      mask << 1;
    }
}  

static int chpid;
static int msgid;
static struct msqid_ds mbuf;
static CBuffer *buffer;
static int input_tty;
static jmp_buf reset;

static daemon_init()
{
  int   fd;
  
  chdir("/");
  umask(0);

  stddebug = fopen("/dev/tty8","w");
}

/*
   output text to vga screen
*/

outc(int con,int c)
{
  static char outbuf[256];
  static int ptr=0;
  static int i;
  

  if (c == -1)
    {
      ch_cursor_blink(0);
      _cwrite(con,outbuf,ptr);
      ch_cursor_blink(1);
      ptr = 0;
      return;
    }
  outbuf[ptr] = c;
  ptr++;
  if (ptr == 255)
    {
      ch_cursor_blink(0);
      _cwrite(con,outbuf,ptr);
      ch_cursor_blink(1);
      ptr = 0;
    }
}

interrupt_vt_control(int curcons)
{
  struct vt_mode mode;
  struct winsize size;
  struct termios buf;
  struct vt_stat stat;

  if (curcons < 0 || curcons >= CONS_NUM)
    return;
  
  if (cap[curcons])
    return;
  
  mode = vmode;
  mode.mode = VT_PROCESS;
  mode.relsig = SIGREL;
  mode.acqsig = SIGACQ;
  ioctl(infd,VT_SETMODE,(int)&mode);
  buf = save_termios;
  buf.c_cc[VMIN] = 1;
  buf.c_cc[VTIME]=0;

  buf.c_lflag &= ~(ECHO |ICANON | IEXTEN | ISIG);
  buf.c_iflag &= ~(BRKINT |ICRNL | INPCK | ISTRIP | IXON);
  buf.c_cflag &= ~(CSIZE | PARENB);
  buf.c_cflag |= CS8;
  buf.c_oflag &= ~(OPOST);

  tcsetattr(infd,TCSAFLUSH,&buf);
  /* In the mean time the nowconsole can be a wrong value */
  /* because the just opened console is not under control */
  /* in the last switch,so we reget the nowconsole here.  */
  ioctl(infd,VT_GETSTATE,(int) &stat);
  nowconsole = stat.v_active-1;
  ch_change_console(nowconsole);
}
restore_vt_control(int curcons)
{
  int i;
  char buf[80];

  if (curcons < 0 || curcons >= CONS_NUM)
    return;

  ioctl(infd,VT_SETMODE,&vmode);
  /* In the mean time,the screen will be filled with trash */
  /* So write blank to screen                              */
  for(i=0;i<80;i++)
    buf[i] = ' ';
  for(i=0;i<25;i++)
    write(infd,buf,80);
}
static int state = 0;

/*
read_chinese_channel()
{
  static int datalen;
  static int con;
  int len,i;
  
  unsigned char *ss = buf;

  len = read(0,buf,256);
  
  for(i=0;i<len;i++)
    {
      D(fprintf(stddebug,"%x ",*ss));
      switch(state)
	{
	case 0:
	  if (trig_unlock && state == 0)
	    {
	      _unlock_vt(0);
	      trig_unlock = 0;
	    }
	  if (trig_lock && state == 0)
	    {
	      _lock_vt(0);
	      trig_lock = 0;
	    }
      
	  if (*ss == 255)
	    state = 1;
	  break;
	case 1:
	  if (*ss == 254)
	    state = 2;
	  break;
	case 2:
	  datalen = *ss;
	  state = 3;
	  break;
	case 3:
	  datalen += 256*(*ss);
	  /* the below code is just a workaround of a error.This error
	     let system hang when exit from chinese shell by 'exit'.We
	     must find who emit the error message */
	  if (datalen == 0xffff)
	    {
	      ss++;
	      state = 0;
	    }
	  else
	    state = 4;
	  break;
	case 4:
	  con = *ss;
	  if (con < 0 || con >= CONS_NUM)
	    state = 0;
	  else
	    state = 5;
	  if (con == nowconsole)
	    ch_write_to_screen(1);
	  else
	    ch_write_to_screen(0);
	  break;
	case 5:
	  switch(*ss)
	    {
	    case CCMD_START:
	      interrupt_vt_control(con);
	      D(fprintf(stddebug,"START\n"));
	      ch_clear_console(con);
	      state = 0;
	      cap[con] = 1;
	      break;
	    case CCMD_END:
	      if (!cap[con])
		return;
	      cap[con] = 0;
	      D(fprintf(stddebug,"CCMD END\n"));
	      restore_vt_control(con);
	      state = 0;
	      break;
	    case CCMD_PRINT:
	      if (!cap[con])
		return;
	      D(fprintf(stddebug,"PRINT\n"));
	      state = 6;
	      break;
	    case CCMD_GRAPH:
	      if (!cap[con])
		return;
	      
	      ch_graphicmode(con);
	      ch_redraw();
	      state = 0;
	      ioctl(infd,KDSETMODE,KD_GRAPHICS);
	      D(fprintf(stddebug,"GRAPHIC %d\n",con));
	      break;
	    case CCMD_TEXT:
	      if (!cap[con])
		return;
	      D(fprintf(stddebug,"TEXT\n"));
	      ch_textmode(con);
	      ioctl(infd,KDSETMODE,KD_TEXT);
	      state = 0;
	      break;
	    case CCMD_INPUT:
	      if (!cap[con])
		return;
	      D(fprintf(stddebug,"INPUT\n"));
	      state = 9;
	      break;
	    case CCMD_ACK:
	      if (!cap[con])
		return;
	      buf[0] = 255;buf[1] = 254;
	      buf[2] = 6;buf[3] = 0;
	      buf[4] = con;
	      buf[5] = 255;buf[6] = 254; buf[7] = buf[8] = 0;
	      buf[9] = con;buf[10] = CCMD_ACK;
	      write(1,buf,11);
	      D(fprintf(stddebug,"%d:ACK\n",con));
	      state = 0;
	      break;
	    case CCMD_SWINSZ:
	      D(fprintf(stddebug,"SWINSZ\n"));
	      if (!cap[con])
		return;
	      state =  10;
	      break;
	    default:
	      D(fprintf(stddebug,"Error %d\n",*ss));
	      state = 0;
	    }
	  break;
	case 6:

	  /*This should't happen */
	  if (datalen <= 0)
	    {
	      state = 0;
	      break;
	    }
	  outc(con,*ss);
	  datalen--;
	  if (datalen == 0)
	    {
	      state = 0;
	      outc(con,-1);
	    }
	  break;
	case 9:
	  ch_inputmethod(*ss);
	  break;
	case 10:
	  {
	    static int x,y;
	    switch(datalen)
	      {
	      case 2:
		D(fprintf(stddebug,"X= %d\n",*ss));
		x = *ss;
		datalen = 1;
		break;
	      case 1:
		y = *ss;
		D(fprintf(stddebug,"Y=%d\n",y));
		ch_setwsize(con,x,y);
		state = 0;
		break;
	      default:
		datalen--;
	      }
	  }
	  break;
	      	      
	default:
	  state = 0;
	  D(fprintf(stddebug,"Error %d\n",*ss));
	}
      ss++;
    }
}
	    
	  
read_tty(int tty)
{
  int len;
  int fd;
  static int lasttty= -1;
  char trbuf[256];

  fd = infd;
  if (lasttty != tty)
    {
      /*  Send the head code */
      len = read(fd,buf+5,100);
      if (len < 0)
	return;
      buf[0] = 255;buf[1] = 254;buf[2] = len;buf[3] = 0;buf[4] = tty;
      len = write(1,buf,len+5)-5;
      lasttty = tty;
    }
  else
    {
      len = read(fd,buf,255);
      len = ch_read_from_buffer(buf,trbuf,len);
      if (len < 0)
	return;
      len = write(1,trbuf,len);
    }
  
}

ioloop()
{
  fd_set readfds;
  int maxfds,mask,i,rtn;
  static struct timeval timeout={600,0};
  static int screen_saver_active = 0;

  while(1)
    {
      if (trig_unlock && state == 0)
	{
	  _unlock_vt(0);
	  trig_unlock = 0;
	}
      if (trig_lock && state == 0)
	{
	  _lock_vt(0);
	  trig_lock = 0;
	}

      FD_ZERO(&readfds);
      FD_SET(0,&readfds);
      maxfds = 0;
      for(i=0;i<CONS_NUM;i++)
	{
	  if (cap[i])
	    {
	      FD_SET(infd,&readfds);
	      if (infd > maxfds)
		maxfds = infd;
	    }
	}

      if ((rtn = select(maxfds+1,&readfds,NULL,NULL,&timeout))>0)
	{
	  timeout.tv_sec = sys_config.blank_time;
	  if (screen_saver_active)
	    {
	      fprintf(stddebug,"End Screen Saver\n");
	      screen_saver_active = 0;
	      ch_screen_saver(END_SAVER);
	    }
	  if (FD_ISSET(0,&readfds))
	    {
	      /* stdin */
	      read_chinese_channel();
	    }
	  
	  for(i = 0;i < CONS_NUM;i++)
	    {
	      if (cap[i])
		{
		  if (FD_ISSET(infd,&readfds))
		    read_tty(i);
		}
	    }
	}
      else if (!screen_saver_active)
	{
	  if (cap[nowconsole] && (timeout.tv_sec == 0))
	    {
	      timeout.tv_sec = 1;
	      fprintf(stddebug,"Start Screen Saver\n");
	      screen_saver_active = 1;
	      ch_screen_saver(START_SAVER);
	    }
	}
      if (screen_saver_active)
	{
	  timeout.tv_sec = 1;
	  fprintf(stddebug,"Saver\n");
	  ch_screen_saver(RUN_SAVER);
	}
    }
}


void newsigint(int signo)
{
  fprintf(stddebug,"SIGINT\n");
  adm_end();
  atexit(Restore_vt_control);
  exit(0);
}

void newsigterm(int signo)
{
  fprintf(stddebug,"SIGTERM\n");
  adm_end();
  atexit(Restore_vt_control);
  exit(0);
}
void newsigkill(int signo)
{
  fprintf(stddebug,"SIGTERM\n");
  adm_end();
  atexit(Restore_vt_control);
  exit(0);
}

void newsigsegv(int signo)
{
  fprintf(stddebug,"SIGSEGV");
  adm_end();
  atexit(Restore_vt_control);
  exit(0);
}

signal_init()
{
  signal(SIGINT,newsigint);
  signal(SIGTERM,newsigterm);
  signal(SIGQUIT,newsigterm);
  signal(SIGSEGV,newsigsegv);
  signal(SIGKILL,newsigkill);
}

void Read_Config()
{
  char *ss;

  sys_config.blank_time = 600;
  if (ss = getenv("CH_BLANK_TIME"))
    {
      sys_config.blank_time = atoi(ss);
    }
  SYSERR1("%d",sys_config.blank_time);
  Read_Console_Config();
  Read_Input_Config();
  Read_Font_Config();
}


main()
{
  int i;
  struct winsize size;
  struct termios buf;


  atexit(adm_end);
  daemon_init();
  Install_vt_control();
  Read_Config();

  fprintf(stddebug,"Chinese driver 0.9 by Yu-Chung Wang 01/24/1994\n");
  adm_init();
  adm_end();
  size.ws_row = 29;
  size.ws_col = 80;
  size.ws_xpixel = 29*16;
  size.ws_ypixel = 80*8;
  for(i=0;i<CONS_NUM;i++)
    {
      ttys[8] = i + '1';
      infd = open(ttys,O_RDWR);
      cap[i] = 0;
      tcgetattr(infd,&save_termios);
    }
  signal_init();
  fprintf(stddebug,"Chinese driver init succefully\n");
  ioloop();
  adm_end();
}









