/* readkeys.cc  ---  Reads the file KEYFILE and evaluates it

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <fstream.h>
#include <stdlib.h>
#include "globals.h"
#include "config.h"
#include "readkeys.h"

// Returns 0 on success, 1 otherwise
int readkeys()
  {
  char keyfilename[PATH_MAX];
  char prefix;
  int  doit, wait, needarg, defaults;
  char key, params[3], keystr[5];
  char label[PATH_MAX], file[PATH_MAX], prompt[PATH_MAX];

  sprintf( keyfilename, "%s%s", homedir, KEYFILE );
  ifstream fkey( keyfilename );
  if ( !fkey )         // Keyfile not found 
    return( 1 );
  
  for ( int i=0; i<256; i++ )
    action[i].defined=FALSE;

  do
    {
    fkey >> prefix;
    if ( prefix=='#' )
      {
      char dummy;
      do { fkey >> dummy; } while ( dummy!='#' );
      continue;
      }
    key = 0;
    fkey >> keystr;
    // Convert keystr into key
    if ( keystr[0]!='$' )
      key = keystr[0];         // Normal key
    else
      if ( keystr[1] == '$' )
        key = '$';             // Escaped $
      else                     // Escaped decimal code
        key = (char)atoi( &keystr[1] );

    fkey >> label;
    fkey >> file;
    fkey >> doit;
    fkey >> wait;
    fkey >> needarg;
    fkey >> prompt;
    fkey >> defaults;
    fkey >> params; 
      
      sprintf( action[key].label, "%c %s", key, label );
      strcpy( action[key].script, file );
      // A little type confusion follows: In KEYFILE doit and wait are
      // ints and so they are here. But in nc.cc the fields action.doit
      // and action.wait are copied to enum BOOL. This is harmless when
      // the enums are defined correctly (FALSE=0, TRUE=1).
      action[key].key  = key;
      action[key].doit = doit;
      action[key].wait = wait;
      action[key].needarg = needarg;      
      action[key].defaults = defaults;
      action[key].defined = TRUE;
      strcpy(action[key].prompt, prompt);
      strcpy(action[key].params, params);
    
    } while( fkey );

  return( 0 );
  }



