/* TFileWindow.h  ---  Header file for TFileWindow.cc  

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _TFileWindow_h
#define _TFileWindow_h

#include "TInfo.h"

class TFileWindow
{
 private:
  class TDir Dir;      // associated directory
  TInfo Info;          // associated long filename line
  int x1, y1, x2, y2;  // position on screen 
  int scrx, scry, scrw, scrh; // dimensions of screen 
  WINDOW *wptr, *std;  // handle of this and of whole screen 
  WINDOW *frameptr;    // The frame box is drawn in its own window
  char cwd[PATH_MAX];
  WHICH which;
  TList List;  // Buffer that holds the filenames
  char dirfilename[PATH_MAX];
  int firstshown;      // First visible entry
  int hilight;         // Highlighted entry
  bool active;
  int maxnum;
  long totalbytes;     // Total bytes of files in window 
  char onscreen[256][256]; // Buffer that holds visible entries
  bool execonly;
  int hascolor;
  char hilightname[PATH_MAX];  // The *string* that was hilighted last

  void fillbuffer( void );  // fills Fname with the directory listing

// insert() returns TRUE if the window is already filled and no more names
// are needed. It returns FALSE if there are still names needed.
  bool insert( TElem *Elem, int num );
  void changehilight( int oldhi, int newhi );

 public:

  TFileWindow( WINDOW *scr, WHICH which ); 
  void remote( char *host );
  void local( void );
  void header( void );
  void summary( void );
  void show( void );
  void showinside( void );
  void repaint( void );
  bool chdir( char *newdir );
  char *telldir( char *dir );
  bool fill( bool readdir );
  char *gethilightedfname( void );

// The difference between the following two functions is that
// gethilightedfmode(), if applied to a link, returns the modes
// of the link; gethilightedtruemode() returns the modes of the
// file or directory the link points to. If gethilightedtruemode()
// is applied to a non-link, it returns the file modes as usual.
// NOTE: 
// get...fmode() returns a string representation of permission
// flags, as they appear in an "ls -la" listing !!! 
// get...truemode() returns the st_mode field of a stat structure,
// as defined in sys/stat.h !!!
  char *gethilightedfmode( void );
  int gethilightedtruemode( void );
  int gethilight( void );
  int getnroflines( void );
  void pageup( void );
  void pagedown( void );
  void sethilight( int value );
  void sethilightname( char *name );
  WINDOW *getwptr( void );
  int getmaxnum( void );
  bool isactive( void );
  void activate( void );
  void top( void );
  void inactivate( void );
  void toggleentry( void );
  void markpattern( char *pattern );
  void unmarkpattern( char *pattern );
  void postprocess( char *lastcommand );
  void makepfile( char *what, char *param );
  void setexeconly( bool value );
  bool getexeconly( void );
  void RemGet( char *remotefile, char *localfile );
  void RemPut( char *localfile, char *remotefile );
};

#endif





