/* TClock.h --- The clock window class  

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _TClock_h
#define _TClock_h

#include <signal.h>
#include <unistd.h>
extern "C" {
#include <ncurses/ncurses.h>
}
#include <time.h>

#include "globals.h"
#include "config.h"


static bool clock_run;
static WINDOW *clock_wptr;
char clockstr[256];
    
class TClock
  {
  private:
    WINDOW *wptr;
    bool killit;

  public:
    TClock( void )
      {
      if (RTC==1)
	{
        wptr = newwin( 1, SCR_X, SCR_Y-5, 0 );
	clock_wptr = wptr;
        leaveok( wptr, TRUE );
        clock_run = TRUE;
        killit = FALSE;
        showtime( 0 );
        }
      }
    
    ~TClock()
      {
      if (RTC==1) delwin( wptr );
      }

    void timeset( char *str )
      {
      time_t timeval;
      char tmp[256];

      tmp[0] = '\0';
      if ( RTC == 1 )
	{
	time( &timeval );
	strcpy( tmp, ctime( &timeval ) );
	}
      
      strcpy( str, tmp );
      }

    
    void start( void )
      {
      clock_run = TRUE;
      showtime( 0 );
      }

    void stop( void )
      {
      clock_run = FALSE;
      alarm( 0 );
      }

    void kill( void )
      {
      killit = TRUE;
      alarm( 0 );
      }

    WINDOW* getwptr( void )
      { return( wptr ); }

    void showtime( int signo )
      {
      if ( clock_run == TRUE )
	{
	signal( SIGALRM, SignalHandler(&showtime) );
        timeset( clockstr );
        werase( clock_wptr );
	wstandout( clock_wptr );
	waddstr( clock_wptr, clockstr );
	wstandend( clock_wptr );
	wrefresh( clock_wptr );
        alarm( 1 );
        }
      else
	alarm( 0 );

      }
  };


#endif


