#include <stdio.h>
#include "gccc.h"
#include "gcopcnt.c"

#define MAXLABELS	512

static short linkTbl[MAXLABELS];

#define fixlabel(n)	codespace[i+n] = linkTbl[codespace[i+n]]
#define fixvar(n)	codespace[i+n] = objects[codespace[i+n]].p

int errs=0;

#ifdef __STDC__
void fixcall(short p) {
#else
void fixcall(p)
	short p;
{
#endif
	if (objects[codespace[p]].p==-1) {
		errs++;
		fprintf(stderr,"Call to undefined function: %s\n",stringspace+namemap[codespace[p]]);
	} else codespace[p] = objects[codespace[p]].p;
}

#ifdef __STDC__
int gclink(void) {
#else
int gclink() {
#endif
	short i = 0, o;
	if (labelcnt>=MAXLABELS) error(ERR_LABELS);
	for (i=0;i<MAXLABELS;i++) linkTbl[i] = -1;
	for (i=0;i<codep;i+=opCnt[o]) {
		if ((o = codespace[i])==OP_LABEL)
			linkTbl[codespace[i+1]] = i;
	}
	for (i=0;i<codep;i+=opCnt[o]) {
		o = codespace[i];
		switch (o) {
		case OP_SPLIT:
			fixvar(3);
			if (codespace[i+4]>=0) fixvar(4);
			break;
		case OP_HEAD:
		case OP_TAIL:
			fixvar(2);
			break;
		case OP_LOOPALL:
			fixvar(1);
			fixlabel(2);
			fixlabel(3);
			break;
		case OP_IF:
		case OP_GOTO:
			fixlabel(1);
			break;
		case OP_EXPAND:
		case OP_LOOKUP:
		case OP_READ:
		case OP_RETURNVAR:
		case OP_SETMATCH:
		case OP_ASSIGN:
		case OP_SETEXPR:
		case OP_TYPEOF:
		case OP_TEST:
			fixvar(1);
			break;
		case OP_BIND:
			if (codespace[i+1]<0) {
				codespace[i+1] = -codespace[i+1];
				fixlabel(2);
			} else fixcall(i+2);
			break;
		case OP_CALL:
			if (codespace[i+1]>=0)
				fixcall(i+1);
			break;
		default:
			break;
		}
	}
	return errs;
}

