#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "gccc.h"

char symtext[512];
int newID = 0;
FILE *keydeffile;
unsigned ch;
int symvalue;
enum symboltype symbol;

char *(cursorKeyNames[]) = {
	"Up", "Down", "Left", "Right",
	"PgUp", "PgDn", "Home", "End",
	"CtlLeft", "CtlRight", "CtlUp", "CtlDown",
	"CtlPgUp", "CtlPgDn", "CtlHome", "CtlEnd",
	"Ins", "Del", "Bkspc"
};

char *reservedWords[] = {
	"BLACK",
#ifdef __MSDOS__
	"BLUE", "GREEN", "CYAN", "RED", "MAGENTA", "BROWN",
#else
#ifdef SYS_V
	"RED", "GREEN", "YELLOW", "BLUE", "MAGENTA", "CYAN",
#else
	"BLUE", "GREEN", "CYAN", "RED", "MAGENTA", "YELLOW",
#endif
#endif
	"WHITE",

	"ACCESS", "ALL", "APPEND", "ASCENDING", "ATIME",
	"BEEP", "BDEV", "BIND", "BREAK", "CALL",
	"CD", "CDEV", "CLEAR", "COLORS", "COLOURS",
	"CONTINUE", "COPY",
	"DEBUG", "DESCENDING", "DIR", "DIRSELECT", "DIRSORT", "DO",
	"DOWN", "ECHO", "ELSE", "END", "ENDREC", "EVAL", "EXEC",
	"EXECCATCH", "EXPAND", "EXTENS", "FILTER", "FOLLOW",
	"GCDEFAULT", "GCSTART", "GROUP",
	"HEAD", "HELP", "HOME", "IF",
	"IF_ANY", "IF_DOS", "IF_UNIX", "IN", "KEYCODE",
	"LEFT", "LENGTH", "LINK", "LOOKUP", "LOOP", "MARK",
	"MARKED", "MATCHES", "METAKEY", "MOVE", "MTIME", "NAME",
	"NEXTLINE", "NONE", "NOT", "OF", "OFF", "ON",
	"OPEN", "OPTION", "OWNER",
	"PAINT", "PERMS", "PGDN", "PGUP", "PIPE", "PLAYMACRO",
	"QUIT", "READ", "RECMACRO", "REG", "RESCAN", "RETURN",
	"RIGHT", "SEARCH", "SHOW", "SHOWHIDDEN", "SIZE", "SLEEP",
	"SORTBY", "SPLIT", "SWAP", "TAIL", "TO", "TYPEOF",
	"UNBIND", "UNLINK", "UNMARK", "UP", "WHILE",  
};

#if __STDC__
static int isReserved(char *name) {
#else
static int isReserved(name)
	char *name;
{
#endif
	int i;
	for (i=0;i<(sizeof(reservedWords)/sizeof(reservedWords[0]));i++)
		if (strcmp(name,reservedWords[i])==0)
			return i;
	return -1;
}

#if __STDC__
short savestring(char *s) {
#else
short savestring(s)
	char *s;
{
#endif
	short rtn = stringp, l = strlen(s);
	stringp += l+1;
	if (stringp >= STRINGSPACE) error(ERR_NAMESTORE);
	strcpy(stringspace+rtn,s);
	return rtn;
}

#if __STDC__
static void nextchar(void) {
#else
static void nextchar() {
#endif
	if (feof(keydeffile)) ch=ETX;
	else do	{
		ch = fgetc(keydeffile);
	} while (!feof(keydeffile) && (ch<32 || ch>127)
		&& ch!='\n' && ch!='\t');
}

#if __STDC__
void nextsymbol(void) {
#else
void nextsymbol() {
#endif
	short length, IDindex, digit, var_ref;
	char *tokenstring, tch;
	int t;
	symbol = SYM_UNDEF;
	newID = 0;
	while (symbol==SYM_UNDEF || !EM) {
		tokenstring = symtext;
		*tokenstring = '\0';
		var_ref = 0;
	        switch (ch) {
		case ETX:	symbol = SYM_EOF;
				break;
		case '\t':
		case ' ': 	nextchar();
				break;
		case '\n':	nextchar();
				fprintf(stderr,"%d\r",++lineno);
				break;
		case '#': 	while (ch!='\n') nextchar();
				break;
                case '(':	nextchar();
                                symbol = SYM_LEFTPARENTHESIS;
                        	break;
                case ')':	symbol = SYM_RIGHTPARENTHESIS;
				nextchar();
				break;
                case '/':	symbol = SYM_REGEXP;
				goto doString;
		case '\'':	
		case '"':
                               	symbol = SYM_STRING;
		doString:
				tch = ch;
				nextchar();
                        	if (ch>=32 && ch<=126) {
					for (;;) {
						if (ch<32 || ch>126)
							error(ERR_STRING);
						if (ch==tch) break;
						*tokenstring++ = (char)ch;
                                        	nextchar();
                                       	}
					nextchar();
				} else error(ERR_STRING);
				*tokenstring = '\0';
                        	break;
                case ';':	symbol = SYM_SEMICOLON;
				nextchar();
				break;
/*              case '+':	symbol = SYM_PLUS;
				nextchar();
				break;
*/
                case '{':	symbol = SYM_LEFTBRACE;
				nextchar();
				break;
                case '}':	symbol = SYM_RIGHTBRACE;
				nextchar();
				break;
		case '[':	nextchar();
				if (ch=='F') {
					nextchar();
					if (ch<'0' || ch>'9') error(ERR_FKEY);
					if (ch=='0') ch=9;
					else ch -= '1';
					symvalue = 20+ch;
					nextchar();
				} else if (ch=='^') {
					nextchar();
					if (ch>='a' && ch<='z') ch -= ('a'-'A');
					else if (ch<'A' || ch>'Z') error(ERR_CTRLKEY);
					symvalue = 30+(ch-'A');
					nextchar();
				} else if (ch=='M' || ch=='m') {
					nextchar();
					if (ch>='0' && ch<='9') ch -= '0';
					else if (ch>='a' && ch<='z') ch -= 'a'-10;
					else if (ch>='A' && ch<='Z') ch -= 'A'-10;
					else error(ERR_METAKEY);
					symvalue = 60+ch;
					nextchar();
				} else if (ch=='\'') {
					nextchar();
					symvalue = ch-' '+100;
					nextchar();
					if (ch != '\'') error(ERR_CHARKEY);
					nextchar();
				} else if (ch=='#') {
					/* Numeric keyspec */
					int k=0;
					nextchar();
					if (EM && !isdigit(ch))
						error(ERR_DIGSPEC);
					while (isdigit(ch)) {
						k = k*10 + ch-'0';
						nextchar();
					}
					symvalue = k;
				} else {
					char name[20], n2[20];
					int i=0;
					if (EM && !isalpha(ch))
						error(ERR_KEYSPEC);
					while (isalpha(ch) && i<18) {
						name[i++] = ch;
						nextchar();
					}
					name[i] = '\0';
					STRUPR(name);
					for (i=0;i<19;i++) {
						strcpy(n2,cursorKeyNames[i]);
						STRUPR(n2);
						if (strcmp(name,n2)==0) {
							symvalue = i;
							break;
						}
					}
					if (i>=19) error(ERR_KEYSPEC);
				}
				if (ch!=']') error(ERR_KEYSPEC);
				nextchar();
				symbol = SYM_KEYSPEC;
				break;
                case '=':	nextchar();
				if (ch=='=') {
					nextchar();
					symbol = SYM_EQUALS;
				} else 	symbol = SYM_ASSIGN;
				break;
#if 0
                case '<':	nextchar();
	                        if (ch=='=') {
	                                symbol = SYM_NOTGREATER;
	                                nextchar();
                                } else if (ch=='>') {
                                        symbol = SYM_NOTEQUAL;
                                        nextchar();
                                } else symbol = SYM_LESS;
	                        break;
                case '>':	nextchar();
	                        if (ch=='=') {
	                                symbol = SYM_NOTLESS;
	                                nextchar();
       	                        } else symbol = SYM_GREATER;
        	                break;
		case '+':	symbol = SYM_PLUS;
				nextchar();
				break;
		case '-':	symbol = SYM_MINUS;
				nextchar();
				break;
               case '*':	symbol = SYM_ASTERISK;
				nextchar();
				break;
                case '[':	symbol = SYM_LEFTBRACKET;
				nextchar();
				break;
                case ']':	symbol = SYM_RIGHTBRACKET;
				nextchar();
				break;
#endif
                case ',':	symbol = SYM_COMMA;
				nextchar();
				break;
                case '$':	nextchar();
				var_ref = 1;
                default:	if (!var_ref && (ch=='-' || (isdigit(ch)))) {
					short sgn = 1, base=10;
					if (ch=='-') {
						sgn = -1;
						nextchar();
	                                        if (!isdigit(ch))
							error(ERR_INTEGER);
					}
                        		symvalue = 0;
					if (ch=='0') {
						nextchar();
						if (ch=='x') {
							base = 16;
							nextchar();
						} else base = 8; /* not supported */
					}
		                        while (isdigit(ch) || (base==16 && isxdigit(ch))) {
                                		if (base==16 && ch>'9') {
							if (ch>'Z') digit = ch-'a'+10;
							else digit = ch-'A'+10;
						} else digit = ch-'0';
						if (symvalue<=(MAXINT-digit)/base) {
                		                        symvalue = base*symvalue+digit;
		                                        nextchar();
	                                        } else error(ERR_INTEGER);
                                       	}
					symvalue *= sgn;
		                        symbol = SYM_INTEGER;
	                        } else if (isalpha(ch) || ch=='_') {
					int oldid = idents-1;
                		        length = 0;
					while (isalnum(ch) || ch=='_') {
               			                if (isupper(ch)) ch = (char)tolower(ch);
                       	   			symtext[length++] = ch;
		                                nextchar();
        	                        }
					symtext[length]='\0';
					STRUPR(symtext);
					if (!var_ref && (t = isReserved(symtext))>=0) {
						symbol = (enum symboltype)(t);
						if (symbol == SYM_IF_ANY ||
						    symbol==SYM_IF_DOS ||
						    symbol==SYM_IF_UNIX) {
#ifdef __MSDOS__
							EM = (symbol==SYM_IF_ANY || symbol==SYM_IF_DOS);
#else
							EM = (symbol==SYM_IF_ANY || symbol==SYM_IF_UNIX);
#endif
							symbol = SYM_UNDEF;
							continue;
						}
					} else if (EM) {
						if ((IDindex = search(symtext,
							var_ref?VAR_TYPE:FUNC_TYPE)) > oldid)
								newID = 1;
               		                	symbol = SYM_IDENTIFIER;
	                               		symvalue = (int)IDindex;
					}
               			} else	{
					symbol = SYM_UNDEF;
					nextchar();
				}
				break;
                }
	}
}

#if __STDC__
void expect(enum symboltype s) {
#else
void expect(s)
	enum symboltype s;
{
#endif
	if (symbol == s) nextsymbol();
	else 	{
		register enum errort e;
		switch(s) {
		case SYM_SEMICOLON:		e = ERR_NOSEMICOLON;
						break;
		case SYM_RIGHTPARENTHESIS:	e = ERR_NORIGHTPAR;
						break;
		case SYM_IDENTIFIER: 		e = ERR_NOIDENT;
						break;
		case SYM_LEFTPARENTHESIS:	e = ERR_NOLEFTPAR;
						break;
		case SYM_COMMA:			e = ERR_NOCOMMA;
						break;
		case SYM_LEFTBRACKET:		e = ERR_NOLEFTBRAK;
						break;
		case SYM_RIGHTBRACKET:		e = ERR_NORIGHTBRAK;
						break;
		case SYM_OF:			e = ERR_NOOF;
						break;
		case SYM_STRING:		e = ERR_NOSTRING;
						break;
		default: 			e = ERR_SYNTAX;
		}
	error(e);
	}
}

#if __STDC__
short expect_ident(void) {
#else
short expect_ident() {
#endif
	int ident = symvalue;
	if (symbol == SYM_IDENTIFIER) nextsymbol();
	else error(ERR_NOIDENT);
	return (short)ident;
}

