#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#ifdef NO_DIRENT_H
#include <sys/dir.h>
#else
#include <dirent.h>
#endif
#ifdef NO_STRING_H
#include <strings.h>
#else
#include <string.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef __MSDOS__
#include <direct.h>
#include <conio.h>
#include <io.h>
#endif

#include "gc3.h"
#include "gcmem.h"

/* Name of file holding old paths */

long	freeSpace,
	usedSpace;
fInfo_t fInfo[2][MAXARGS];	/* Directory info for each panel */
char	paths[2][MAXPATHNAME];

static char	oldPaths[2][MAXPATHNAME] = { "", "" };
static char	*oldSelNames[MAXARGS];
static int	totfiles[2]={0,0};

#ifdef NO_GETCWD
static void GETCWD(char *name) {
	FILE *fp;
	char *n = tmpnam(NULL), buf[64];
	sprintf(buf,"pwd > %s",n);
	system(buf);
	if ((fp = fopen(n,"r")) != NULL) {
		fscanf(fp,"%s",name);
		fclose(fp);
		unlink(n);
	}
}
#else
#define GETCWD(n)	(void)getcwd(n,MAXPATHNAME+MAXFILENAME)
#endif

#if	__STDC__
char *getPerms(mode_t tmd) {
#else
char *getPerms(tmd)
	mode_t tmd;
{
#endif
	static char perms[14];
#ifdef __MSDOS__
	strcpy(perms, (tmd&S_IWRITE) ? "RW" : "RO");
#else
	int i = 0;
	perms[i++] = (tmd&S_ISUID) ? 's' : '-';
	perms[i++] = (tmd&S_ISGID) ? 'S' : '-';
#ifdef S_ISVTX
	perms[i++] = (tmd&S_ISVTX) ? 't' : '-';
#endif
#ifdef S_IRUSR
	perms[i++] = (tmd&S_IRUSR) ? 'r' : '-';
	perms[i++] = (tmd&S_IWUSR) ? 'w' : '-';
	perms[i++] = (tmd&S_IXUSR) ? 'x' : '-';
	perms[i++] = (tmd&S_IRGRP) ? 'r' : '-';
	perms[i++] = (tmd&S_IWGRP) ? 'w' : '-';
	perms[i++] = (tmd&S_IXGRP) ? 'x' : '-';
	perms[i++] = (tmd&S_IROTH) ? 'r' : '-';
	perms[i++] = (tmd&S_IWOTH) ? 'w' : '-';
	perms[i++] = (tmd&S_IXOTH) ? 'x' : '-';
#else /* None-POSIX; owners permissions only */
	perms[i++] = (tmd&S_IREAD) ? 'r' : '-';
	perms[i++] = (tmd&S_IWRITE) ? 'w' : '-';
	perms[i++] = (tmd&S_IEXEC) ? 'x' : '-';
#endif
	perms[i++]=0;
#endif
	return perms;
}

#if __STDC__
int checkType(mode_t m, short f) {
#else
int checkType(m, f)
	mode_t m;
	short f;
{
#endif
	int rtn = 0;
#ifndef __MSDOS__
	if (S_ISLNK(m) && (f & 64)) rtn=1;
#endif
	if (S_ISCHR(m) && (f & 4)) rtn = 1;
	if (S_ISBLK(m) && (f & 8)) rtn = 1;
	if (S_ISFIFO(m) && (f & 2)) rtn = 1;
	if (S_ISDIR(m) && (f & 1)) rtn = 1;
	if (S_ISREG(m)) {
		if (f & 32)
#ifdef S_IXUSR
			if ((m&(S_IXUSR|S_IXGRP|S_IXOTH))==0)
#else
			if ((m&(S_IEXEC))==0)
#endif
				rtn = 1;
		if (f & 16) rtn = 1;
	}
	return rtn;
}

/*********************************************************
		DIRECTORY CHANGING AND READING
**********************************************************/

/*
 * refilter filters the indexes for the directory l
 */

#if __STDC__
void refilter(int l, char *oldname) {
#else
void refilter(l, oldname) 
	int l;
	char *oldname;
{
#endif
	int i, j=0;
	(void)compileRE(filters[l]);
	for (i=0;i<totfiles[l];i++) {
		if (matchRE(fInfo[l][i].name)==1)
			fIndex[l][j++] = i;
	}
	numfiles[l] = j;
	sortList(l,oldname);
	normalise(l);
}

/*
 * readList is called after a shell command (!), startup, or
 * a change of directory. It rescans and resorts the directory.
 */

/* Once upon a time this was all simple, using opendir,
   readdir and closedir. Then I decided to handle hidden
   files. Trivial under UNIX, but a pain under DOS. This
   is the mess that resulted....
*/

#ifdef __MSDOS__
#include <dos.h>
static int startDir = 1;
static char dirPath[80];
#else
#  ifdef NO_DIRENT_H
  static int startDir = -1;
#  else
  static DIR *startDir = NULL;
#  endif
#endif

#if __STDC__
static void *initDir(char *pname) {
#else
static void *initDir(pname)
	char *pname;
{
#endif
#ifdef __MSDOS__
	startDir = 1;
	strcpy(dirPath,pname);
	if (dirPath[strlen(dirPath)-1]!='\\')
		strcat(dirPath,"\\*.*");
	else strcat(dirPath,"*.*");
	return (void *)1;
#else
#  ifdef NO_DIRENT_H
	return (void *)((startDir = open(pname,0))+1);
#  else
	return (void *)(startDir = opendir(pname));
#  endif
#endif
}

#if __STDC__
static char *getDirEntry(void) {
#else
static char *getDirEntry() {
#endif
#if __MSDOS__
	static struct ffblk fdat;
	if (startDir) {
		startDir = 0;
		if (findfirst(dirPath,&fdat,
			(showHidden?FA_HIDDEN:0)|FA_RDONLY|FA_DIREC|FA_ARCH))
				return NULL;
	} else if (findnext(&fdat)) return NULL;
	return fdat.ff_name;
#else
#ifdef NO_DIRENT_H
	static struct direct de;
	if (startDir>=0) {
		while (read(startDir,&de,sizeof(de))==sizeof(de)) {
			if (showHidden==0 && de.d_name[0]=='.' &&
				strcmp(de.d_name,"..")!=0)
					continue;
			else return de.d_name;
		}
	}
	return NULL;
#else
	struct dirent *de;
	if (startDir) {
		while ((de=(struct dirent *)readdir(startDir))!=NULL) {
			if (showHidden==0 && de->d_name[0]=='.' &&
				strcmp(de->d_name,"..")!=0)
					continue;
			else return de->d_name;
		}
	}
	return NULL;
#endif
#endif
}

#if	__STDC__
static void closeDir(void) {
#else
static void closeDir() {
#endif
#ifndef __MSDOS__
#  ifdef NO_DIRENT_H
	close(startDir);
#  else
	closedir(startDir);
#  endif
#endif
}

#if __STDC__
static void addEntry(char *pathname, int n,  int i, char *fname, int j) {
#else
static void addEntry(pathname, n,  i, fname, j)
	char *pathname, *fname;
	int n, i, j;
{
#endif
	int k;
	struct stat st;
	fInfo_t *f = &fInfo[n][i];
#ifdef NO_SYMLINKS
	if (stat(pathname,&st)==0) {
#else
#ifdef __STDC__
	if ((followLinks?stat:lstat)(pathname,&st)==0) {
#else
	if (( followLinks &&  stat(pathname,&st)==0) ||
	    (!followLinks && lstat(pathname,&st)==0)) {
#endif
#endif
		f->size = st.st_size;
		f->mode = st.st_mode;
		f->uid = st.st_uid;
		f->gid = st.st_gid;
		f->modtime = st.st_mtime;
		f->acctime = st.st_atime;
		{
	  	  register mode_t m = f->mode;
#ifndef __MSDOS__
	  	  if (!followLinks && S_ISLNK(m)) f->typID = 'l'; else
#endif
	  	  if (S_ISDIR(m)) f->typID = PATH_SEP;
	  	  else if (S_ISCHR(m)) f->typID = 'c';
	  	  else if (S_ISBLK(m)) f->typID = 'b';
	  	  else if (S_ISFIFO(m)) f->typID = 'p';
#ifdef S_IXUSR
	  	  else if (m & (S_IXUSR|S_IXGRP|S_IXOTH))
#else
	  	  else if (m & (S_IEXEC))
#endif
			f->typID = '*';
#ifndef __MSDOS__
	  	  else if (followLinks && S_ISLNK(m)) f->typID = 'l';
#endif
	  	  else f->typID = ' ';
		}
		f->flag = 0;
		if ((f->name = Mem_Calloc(strlen(fname)+1,sizeof(char),6))!=NULL)
			strcpy(f->name,fname);
		fIndex[n][i] = i;
		for (k=0;k<j;k++) {
			if (strcmp(oldSelNames[k],fname)==0) {
				f->flag = F_SELECTED;
				selCnt[n]++;
				selSize[n] += f->size;
				break;
			}
		}
	} else {
		int buf = getBuffer(267);
		sprintf(BUF[buf],"Cannot stat %s!",pathname);
		showMsg(BUF[buf]);
		releaseBuffer(buf,267);
	}
}
	
#if	__STDC__
void readList(int n, char *name, int newpath) {
#else
void readList(n, name, newpath)
	int n;
	char *name;
	int newpath;
{
#endif /* __STDC__ */
	int i, j, buf;
	struct stat st;
	char *oldname=NULL, nbuf[256], *fname;
	if (initDir(paths[n])==NULL) return; /* Should produce an error */
	if (name) strcpy(oldname = nbuf, name);

	if (oldPaths[n][0]) newpath = strcmp(oldPaths[n],paths[n]);
	strcpy(oldPaths[n],paths[n]);
	/* Save old selected file names, free the rest */
	for (i=j=0;i<totfiles[n];i++) {
		if (!newpath && (fInfo[n][i].flag&F_SELECTED))
			oldSelNames[j++] = fInfo[n][i].name;
		else if (fInfo[n][i].name) 
			Mem_Free(fInfo[n][i].name,2);
		fInfo[n][i].name = NULL;
	}
	selCnt[n] = selSize[n] = i = 0;
	buf = getBuffer(200);
	while ((fname=getDirEntry())!=NULL) {
		if (strcmp(fname,".")==0) continue;
		strcpy(BUF[buf],paths[n]);
#ifdef __MSDOS__
		if (BUF[buf][strlen(BUF[buf])-1]!='\\') strcat(BUF[buf],"\\");
#else
		if (BUF[buf][strlen(BUF[buf])-1]!='/') strcat(BUF[buf],"/");
#endif
		strcat(BUF[buf],fname);
		addEntry(BUF[buf],n,i++,fname,j);
		if (i>=MAXARGS) break;
	}
	if (i == 0) addEntry(".",n,i++,".",j);/* Must have one entry at least */
	releaseBuffer(buf,1);
	totfiles[n] = i;
	if (newpath) highlight[n]=0;
	closeDir();
	if (!newpath) 
		while (--j >= 0)
			Mem_Free(oldSelNames[j],3);
	refilter(n,oldname);
}

#if	__STDC__
void freeNames(int n) {
#else
void freeNames(n)
	int n;
{
#endif /* __STDC__ */
	int i;
	for (i=0;i<totfiles[n];i++) {
		if (fInfo[n][i].name) {
			Mem_Free(fInfo[n][i].name,15);
			fInfo[n][i].name = NULL;
		}
	}
}

#if	__STDC__
void getCWD(char *name) {
#else
void getCWD(name)
	char *name;
{
#endif /* __STDC__ */
	GETCWD(name);
}

#if	__STDC__
static void reScan(char *name) {
#else
static void reScan(name)
	char *name;
{
#endif /* __STDC__ */
	getCWD(paths[l]);
	readList(l,name,1);
	showPath(l);
}

/*
 * Change to a specified directory, and fix up the paths[] variable
 *	appropriately.
 */

#ifdef __MSDOS__
void mychdir(char *d) {
	if (d[1]==':') {
		(void)_chdrive(toupper(d[0])-'A'+1);
		d+=2;
	}
	(void)chdir(d);
}
#endif


/*
 * The two routines below are OS-specific just to make it
 * easier to understand what's happening. The differences are
 * the path separator character and the fact that DOS can
 * have a drive specifier at the front. They need to be 
 * rewritten to parse generalised relative path specifiers
 * as well. The only relative path allowed is a subdirectory
 * of the current directory or the parent .. of the current.
 * This is OK for changing by pressing enter on a file name
 * in the window, but not good enough for handling arbitrary
 * paths entered in user commands. 
 */

#ifdef __MSDOS__
static int DOSdoCD(char *d, char **oldname, int buf) {
	strcpy(BUF[buf],paths[l]);
	if (strcmp(d,"..")==0) {
		char *p = (char *)strrchr(paths[l],PATH_SEP);
		strcpy(BUF[buf],p+1);
		if (p==(paths[l]+2)) { /* root dir on drive */
			if (p[1]) p[1] = '\0';
			else BEEP;
		} else *p = '\0';
		if (oldname) *oldname = BUF[buf];
	}  else if (d[0]==PATH_SEP) {
		if (paths[l]!=d) strcpy(paths[l],d);
	} else if (d[1]==':') {
		unsigned drv, ndrv;
		if (d[2]=='\0') strcat(d,"\\");
		strcpy(paths[l],d);
		if (d[0]>='a') drv = d[0]-'a';
		else drv = d[0]-'A';
		_dos_setdrive(drv+1,&ndrv);
		if (_dos_getdrive(&ndrv), ndrv!=(drv+1)) {
			reScan(NULL);
			sprintf(BUF[buf],"Cannot change to drive %c",'A'+drv);
			showMsg(BUF[buf]);
			return -1;
		}
	}  else {
		if (paths[l][strlen(paths[l])-1]!='\\')
			strcat(paths[l],"\\");
		strcat(paths[l],d);
	}
	return chdir(paths[l]);
}

#else
#if	__STDC__
static int UNIXdoCD(char *d, char **oldname, int buf) {
#else
static int UNIXdoCD(d, oldname, buf)
	char *d, **oldname;
	int buf;
{
#endif /* __STDC__ */
	/* Convert a path spec into an absolute path */
	strcpy(BUF[buf],paths[l]);
	if (d[0]==PATH_SEP) { /* Absolute path - easy */
		if (paths[l]!=d) strcpy(paths[l],d);
	} else if (strcmp(d,"..")==0) {
		/* Go up one directory in current paths[l],
			saving the last current directory 
			with oldname. */
		char *p = (char *)strrchr(paths[l],PATH_SEP);
		strcpy(BUF[buf],p+1);
		if (p==paths[l]) { /* root dir */
			if (p[1]) p[1] = '\0';
			else BEEP; /* Can't go up from root */
		} else *p = '\0';
		if (oldname) *oldname = BUF[buf];
	}  else { /* subdirectory */
		if (paths[l][strlen(paths[l])-1]!='/')
			strcat(paths[l],"/");
		strcat(paths[l],d);
	}
	return chdir(paths[l]);
}
#endif

#if	__STDC__
void doCD(char *d, char *oldname) {
#else
void doCD(d, oldname)
	char *d, *oldname;
{
#endif /* __STDC__ */
	int buf;
	if (strcmp(d,".")==0) return;
	buf = getBuffer(201);
	strcpy(BUF[buf],paths[l]);
#ifdef __MSDOS__
	if (DOSdoCD(d,&oldname,buf)==0) {
#else
	if (UNIXdoCD(d,&oldname,buf)==0) {
#endif
		reScan(oldname);
		showList(l);
		clearCmdWin();
	} else {
#ifdef NO_STRERROR
		char *msg = NULL;
#else
		char *msg = strerror(errno);
#endif
		reScan(oldname);
		sprintf(BUF[buf],"Failed to change to directory %s %c %s",
			d, msg ? '-' : ' ', msg ? msg : "");
		showMsg(BUF[buf]);
	}
	releaseBuffer(buf,4);
}

/*****************************************************************
		SAVE AND RESTORE STATE
******************************************************************/

#if	__STDC__
static int getOldPath(char *fname) {
#else
static int getOldPath(fname)
	char *fname;
{
#endif /* __STDC__ */
	FILE *fp;
	paths[0][0] = paths[1][0] = '\0';
	if ((fp = fopen(fname,"r"))!=NULL) {
		int buf = getBuffer(202), i, l;
		fscanf(fp,"%s",paths[1]);
		fscanf(fp,"%d %d %d %d", &noDirSelect, &dirsFirst,
			 &showHidden, &followLinks);
		i=LASTPREDEFVAR+1;
		fgets(BUF[buf],BUFFER_SIZE,fp);
		while (!feof(fp)) {
			fgets(BUF[buf],BUFFER_SIZE,fp);
			if ((l = strlen(BUF[buf])) > 0) BUF[buf][l-1]='\0';
			assign2var(i++,BUF[buf]);
		}
		fclose(fp);
		return 0;
	} else return -1;
}

#if	__STDC__
void savePath(void) {
#else
void savePath() {
#endif /* __STDC__ */
	FILE *fp;
	int buf = getBuffer(202), i;
	if (getenv("GCPATH")) strcpy(BUF[buf],getenv("GCPATH"));
#ifndef __MSDOS__
	else if (getenv("HOME")) strcpy(BUF[buf],getenv("HOME"));
#endif
	else strcpy(BUF[buf],".");
	strcat(BUF[buf],INIANAME);
	if ((fp = fopen(BUF[buf],"w"))!=NULL) {
		if (getenv("GCPATH")) fprintf(fp,"%s\n",paths[l]);
#ifndef __MSDOS__
		else if (getenv("HOME")) fprintf(fp,"%s\n",paths[l]);
#endif
		/* The active directory is the directory
		   the file gets saved in, so in
		   this case we save the other directory. */
		else fprintf(fp,"%s\n",paths[1-l]);
		fprintf(fp,"%d %d %d %d", noDirSelect, dirsFirst,
			 showHidden, followLinks);
		for (i=LASTPREDEFVAR+1;i<idents;i++) {
			if ((objects[i].type&FUNC_TYPE)==0) {
				int idx = (int)objects[i].p;
				fprintf(fp,"%s\n",lookupVar(idx,buf));
			}
		}
		fclose(fp);
	}
	releaseBuffer(buf,5);
}


#ifdef __MSDOS__
void getDiskSpace(char *path) {
	unsigned char drv=0;
	struct dfree df;
	long csiz; /* bytes/cluster */
	if (path)
		if (path[1]==':')
			if (path[0]>'Z') drv = (unsigned char)(path[0]-'a'+1);
			else drv = (unsigned char)(path[0]-'A'+1);
	getdfree(drv,&df);
	csiz = (long)df.df_sclus * (long)df.df_bsec;
	freeSpace = csiz * (long)df.df_avail;
	usedSpace = csiz * (long)df.df_total - freeSpace;
}
#else
#if __STDC__
void getDiskSpace(char *path) {
#else
void getDiskSpace(path)
	char *path;
{
#endif
}
#endif

#ifdef __MSDOS__
int doFileCopy(char *src, char *dest, int del) {
	int i, isFile = 1, rtn = 0;
	unsigned bsiz=4096;
	FILE *inF, *outF;
	char *destination=Mem_Calloc(MAXPATHNAME+MAXFILENAME+1,sizeof(char),8),
		*fbuff;
	if (destination==NULL) return -1;
	strcpy(destination,dest);
	/* check if dest is a directory or not */
	if (access(dest,0)==0) {
		struct stat s;
		if (stat(dest,&s)==0) {
			if (S_ISDIR(s.st_mode)) {
				isFile = 0;
			}
		}
	}
	if (isFile==0) {
		i = (int)strlen(src);
		if (destination[strlen(destination)-1]!='\\')
			strcat(destination,"\\");
		while (src[i]!='\\' && src[i]!=':' && i>=0) i--;
		strcat(destination,src+i+1);
	}
	if ((fbuff = Mem_Calloc(bsiz,sizeof(char),9))==NULL) {
		bsiz /= 2;
		if ((fbuff = Mem_Calloc(bsiz,sizeof(char),10))==NULL) {
			bsiz /= 2;
			if ((fbuff = Mem_Calloc(bsiz,sizeof(char),11))==NULL) {
				showMsg("Cannot allocate disk buffer");
				rtn= -4;
				goto fail1;
			}
		}
	}
	if ((inF = fopen(src,"rb"))==NULL) {
#ifdef NO_STRERROR
		sprintf(fbuff,"Cannot open %s for input",src);
#else
		sprintf(fbuff,"Cannot open %s for input: %s",src,
				strerror(errno));
#endif
		showMsg(fbuff);
		rtn = -2;
		goto fail2;
	}
	if ((outF = fopen(destination,"wb"))==NULL) {
#ifdef NO_STRERROR
		sprintf(fbuff,"Cannot open %s for output",destination);
#else
		sprintf(fbuff,"Cannot open %s for output: %s",destination,
				strerror(errno));
#endif
		showMsg(fbuff);
		rtn = -3;
		goto fail3;
	}
	while (!feof(inF)) {
		unsigned i;
		if ((i=fread(fbuff,sizeof(char),bsiz,inF))>0)
			fwrite(fbuff,sizeof(char),i,outF);
	}
	fclose(outF);
	if (del) unlink(src);
fail3:
	fclose(inF);
fail2:
	Mem_Free(fbuff,10);
fail1:
	Mem_Free(destination,11);
	return rtn;
}
#endif

#if __STDC__
void dirInit(int args, char *arg1, char *arg2) {
#else
void dirInit(args, arg1, arg2)
	int args;
	char *arg1, *arg2;
{
#endif
	(void)readFile(ININAME,INIANAME,getOldPath);
	if (args) strcpy(paths[0],arg1);
        else if (paths[0][0]=='\0')
		GETCWD(paths[0]);
	if (args==2) strcpy(paths[1],arg2);
	else if (paths[1][0]=='\0')
		GETCWD(paths[1]);
	/* Make sure boths paths are accessible and absolute */
	CHDIR(paths[1]); GETCWD(paths[1]);
	CHDIR(paths[0]); GETCWD(paths[0]);
	readList(0,NULL,1);
	readList(1,NULL,1);
}

#if	__STDC__
void cd2old(void) {
#else
void cd2old()
{
#endif /* __STDC__ */
	CHDIR(paths[l]);
	showPath(l);
	clearCmdWin();
}

