/*
 * Stuff common to the compiler and interpreter
 */

#ifndef _GCBOTH_H
#define _GCBOTH_H

/* Sort keys */

#define S_NAME		0
#define S_SIZE		1
#define S_MTIME		2
#define S_ATIME		3
#define S_OWNER		4
#define S_GROUP		5
#define S_EXTENS	6

/* Variables */

#define MAXVARS		100	/* Maximum number of string variables	*/

#define LASTPREDEFVAR	26

#define VAR_PFILE	0
#define VAR_SFILE	1
#define VAR_PFILES	2
#define VAR_SFILES	3
#define VAR_PPATH	4
#define VAR_SPATH	5
#define VAR_PSEL	6
#define VAR_SSEL	7
#define VAR_PSELSIZE	8
#define VAR_SSELSIZE	9
#define VAR_PSELCNT	10
#define VAR_SSELCNT	11
#define VAR_PSIZE	12
#define VAR_SSIZE	13
#define VAR_NAME	14
#define VAR_TEMPNAME	15
#define VAR_LINEBUFF	16
#define VAR_DATE	17
#define VAR_TIME	18
#define VAR_RANDOM	19
#define VAR_PREVCMD	20
#define VAR_NEXTCMD	21
#define VAR_DISKFREE	22
#define VAR_DISKUSED	23
#define VAR_MESSAGE	24
#define VAR_SHELL	25
#define VAR_CH		26

/* Buffer space */

#define MAX_BUFFERS	8	/* Number of temporary string buffers	*/
#define BUFFER_SIZE	1024	/* Size of each temp string buffer	*/
#define STRINGSPACE	6000
#define CODESPACE	4096

#define FUNC_TYPE	((short)1)
#define VAR_TYPE	((short)2)

typedef struct {
	short	p;	/* Pointer into code space, or var space */
	short	type;
} objectrecord;

extern short		idents,
			codep,
			stringp;
extern int		lineno;
extern short		namemap[];
extern objectrecord 	objects[];
extern char		stringspace[];
extern short		codespace[];
extern short		initialEntryPoint;
extern short		defaultEntryPoint;

#ifdef __MSDOS__
#  ifndef __STDC__
#  	define __STDC__	1
#  endif
#  include "doscfg.h"
#else
#  ifdef NO_MODE_T
	typedef unsigned short mode_t;
#  endif
#  include "unixcfg.h"
#endif

/*
 * Prototypes from gcutil.c
 */

#if __STDC__
extern int	getBuffer(int who);
extern void	releaseBuffer(int buf, int who);
extern void	STRUPR(char *s);
extern int	readcode(char *path);
extern int	readFile(char *name, char *aname,int (*f)(char *));
extern void	writecodefile(void);
#else
extern int	getBuffer();
extern void	releaseBuffer();
extern void	STRUPR();
extern int	readcode();
extern int	readFile();
extern void	writecodefile();
#endif

#endif

