/*
 * gc - Gram's Commander: A Norton-Commanderish utility version 3.1
 *
 * YAGH! (tm) (Yet Another Gramish Hack)
 *
 * Please contribute suggestions/bug reports, etc. If you use
 * this program regularly, you are requested to send a contribution
 * of US $10 to the author, at P.O.Box 15525, Vlaeberg, 8018, South Africa.
 * I lost about a month's income writing this program, so I can use it!
 * This will encourage the development of enhancements to this program,
 * and other utilities you always wish you had. I will give half of each
 * contribution to charity (if you send more than $10, any extra will
 * also be given to charity).
 *
 * This program may be freely copied and distributed, provided this message
 * and the title screen are retained and all modifications are noted
 * and accredited at the end of this message.
 *
 * Written by Graham Wheeler, Aztec Information Managment
 * 	gram@aim1.aztec.co.za
 *
 * TO INSTALL: See the document `gc3.doc' for full details. You
 * 	must modify the Makefile and the unixcfg.h and doscfg.h
 *	header files to your satisfaction, and then do a `make'.
 *	Under UNIX this should be followed by a `make install'.
 *
 * Version History
 * ---------------
 * v1.0	  10 Nov 1992		Initial release
 * v2.0	  15 Nov 1992		Largely rewritten to be table-driven
 * v2.1    4 Dec 1992		Support for non-ANSI C compilers contributed
 *					by George Sipe
 *				Support for old ioctls TCGETA and TCSETAW
 *					for those with no POSIX-style
 *					tcgetattr and tcsetattr.
 * v2.2	  13 Dec 1992		Termio ioctls removed.Hopefully much
 *					more portable. Command mode
 *					has been taken out. A few
 *					bugs fixed. Placeholder replacement
 *					now done in a preprocessing phase
 *					before parsing commands.
 * v2.3	  10 Jan 1993		Split into a number of source files
 *				Basic port to MS-DOS
 * v3.0	  Feb/March '93		New script language; large parts rewritten
 * v3.1	  March '93		Ported back to UNIX and cleaned up
 *
 * DISCLAIMER: The author is not responsible for any loss, damage,
 *	riots, earthquakes, catastrophes, marriages, annulments,
 *	etc that arise from the	use of this program. Sorry...
 *
 */

#include <sys/types.h>
/*#include <sys/stat.h>*/
#include <errno.h>

#ifdef NO_STRING_H
#include <strings.h>
#else
#include <string.h>
#endif

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
/*#include <dirent.h>*/
#include <time.h>

#include "gc3.h"
#include "gcmem.h"
#include "gckey.h"

#ifdef __MSDOS__
#include <io.h>
#include <conio.h>
#include <direct.h>
#else
#include <grp.h>
#include <pwd.h>
#endif

int	l;		/* Current active panel	*/
short	escapeCh;
int	numfiles[2]={0,0},
	fIndex[2][MAXARGS],
	highlight[2],
	startLn[2],
	selCnt[2],
	metaKey = 0,	/* Special key for keyboards without Alt- */
	allowColor,
	metaMode = 0,
	searching = 0;
long	selSize[2];
short	info2show=1;
char	srchTxt[80];

#ifdef DEBUG
FILE *debug;
#endif

#if	__STDC__
static int srchMatch(int n, int ch) {
#else
static int srchMatch(n, ch)
	int n, ch;
{
#endif /* __STDC__ */
	unsigned L = strlen(srchTxt);
	int H = highlight[n];
#ifdef __MSDOS__
	srchTxt[L] = (char)((islower(ch)) ? (toupper(ch)) : ch);
#else
	srchTxt[L] = (char)ch;
#endif
	srchTxt[L+1]='\0';
	do {
		if (strncmp(fInfo[n][fIndex[n][H]].name,srchTxt,L+1)==0) {
			highlight[n] = H;
			normalise(n);
			repaintScreen();
			return 1;
		}
		H++;
		if (H==numfiles[n]) H=0;
	} while (H != highlight[n]);
	srchTxt[L] = '\0';
	return 0;
}

#if	__STDC__
static void loop(void) {
#else
static void loop()
{
#endif /* __STDC__ */
	int k, ch, buf;
	char *msg = lookupVar(24,buf=getBuffer(400));
	if (msg && msg[0]) showMsg(msg);
	releaseBuffer(buf,290);
	for (;;) {
		if (searching) clearCmdWin();
		showCursor(1-l,0);
		showCursor(l,1);
		refreshScreen();
		if (escapeCh != -1)  {
			ch = escapeCh;
			escapeCh = -1;
		} else ch = my_getch();
		if (ch == metaKey || ch==27) {
			if (searching) searching=0;
			else metaMode = 1 + (ch==metaKey);
			ch = my_getch();
		}
		hideCursor(1-l); hideCursor(l);
		clearCmdWin();
		msg = lookupVar(24,buf=getBuffer(401));
		if (msg && msg[0]) showMsg(msg);
		releaseBuffer(buf,200);
		if (searching) {
			if (isprint((int)ch) && !isspace((int)ch)) {
				if (!srchMatch(l, ch)) BEEP;
				continue;
			} else {
				searching = 0;
				srchTxt[0]='\0';
				clearCmdWin();
			}
		}
		k = getKeyBinding(ch, 1);
		if (k<0) { 
			/*if (isprint((int)ch)) doDefaultAction(ch);*/
			if (isprint((int)ch)) {
				(void)execute(defaultEntryPoint,ch);
			} else BEEP;
		} else if (k==999) break;
		repaintScreen();
	}
}

#if	__STDC__
main(int argc, char *argv[]) {
#else
main(argc, argv)
	int argc;
	char **argv;
{
#endif /* __STDC__ */
	int i=1;
	Mem_Init();
	allowColor=1;
	while (i<argc && argv[i][0]=='-') {
		switch(argv[i][1]) {
		case 'c': allowColor = 0;
			break;
		default:
			fprintf(stderr,"Useage: gc3 [-c] [ <path1> [ <path2> ] ]\n");
			exit(0);
		}
		i++;
	}
	setupCurses("v3.1");
	dirInit(argc-i, argv[i], argv[i+1]);
#ifdef DEBUG
	debug = fopen("gc.bug","w");
#endif
	clearKeyTable();
	if (readFile(CODNAME,CODANAME,readcode)) {
		int e = errno;
		exitCurses();
#ifdef NO_STRERROR
		fprintf(stderr,"Cannot open code file: errno %d\n",e);
#else
		fprintf(stderr,"Cannot open code file: %s\n",strerror(e));
#endif
		exit(0);
	}
#ifdef __MSDOS__
	if (getenv("TMP"))
		strcpy(tempName,getenv("TMP"));
	else if (getenv("GCPATH"))
		strcpy(tempName,getenv("GCPATH"));
	else strcpy(tempName,"c:");
	strcat(tempName,"\\");
	strcat(tempName,tmpname(NULL));
#else
	strcpy(tempName,tempnam((const char *)NULL, (const char *)NULL));
#endif
	if (initialEntryPoint) (void)execute(initialEntryPoint,0);
	repaintScreen();
	escapeCh = -1;
	metaMode = 0;
	srchTxt[0]='\0';
	loop();
	savePath();
	unlink(tempName);
	freeVars();
	freeNames(0);
	freeNames(1);
	Mem_Check(1);
	return 0;
}


