#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <linux/fs.h>
#include <linux/major.h>

#define FDFORMAT "/usr/bin/fdformat"

/* Este programa permite llamar a fdformat a un usuario normal 
   controlando que no haga trampas... (puede formatear solo los 
   /dev/fd[0-1]* y solo si no son links. */

int main(int argc, char* argv[]) {

  uid_t realuser;
  int fd;
  char* floppy;
  struct stat floppy_stat;
  realuser=getuid();
  floppy=argv[1];

  if (geteuid()) {
    fprintf(stderr,"%s: I must be installed setuid root!\n",argv[0]);
    exit(1);
  }

  if ( strncmp(floppy,"/dev/fd0",8) && strncmp(floppy,"/dev/fd1",8) ) {
    fprintf(stderr,"Normal user can only format /dev/fd[01]* devices\n");
    exit(1);
  }

  /* Can I open file? Change my uid to realuser and try */

  setreuid(0,realuser); 
  fd=open(floppy, O_RDWR);
  if (fd==-1) {
    perror(floppy);
    exit(1);
  }

  /* Ok, back to superuser */

  setreuid(realuser,0);

  if (fstat(fd,&floppy_stat)==-1 ) {
    perror(floppy);
    exit(1);
  }

  if (MAJOR(floppy_stat.st_rdev)!=FLOPPY_MAJOR) {
    fprintf(stderr,"Huh? %s is not a floppy! \n",floppy);
    exit(1);
  }

  if (close(fd)==-1) {
    perror("Close??? ");
    exit(1);
  }

  execv(FDFORMAT,argv);

  perror("exec :");
  exit(1);
  
}
 

  
