/***********************************************************
*  macformat.c -- write a mac filesystem on a floppy disk  *
*----------------------------------------------------------*
*  1995 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.owl.de                      *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
***********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

#include "global.h"
#include "block1.h"
#include "block2.h"

#define MIN(a,b)        (((a)<(b))?(a):(b))
#define MAX(a,b)        (((a)>(b))?(a):(b))

#define MAX_LABELLENGTH	27
#define DEF_EMPTYLABEL	"Empty"

void SetDiskLabel(char *);
void WriteDiskBlocks(char *, unsigned char *, int, int);

int main(int argc, char **argv)
{
  char progname[1024];

  strcpy(progname,GetFilename(argv[0]));

  if (argc<2 || argc>3 ||
      argc==2 && (!strcmp(argv[1],"-?") || !strcmp(argv[1],"-h")))
  {
    fprintf(stderr,"Usage: %s <disk device> [volume label]\n",progname);
    exit(-1);
  }

  SetDiskLabel(argc==3 ? argv[2] : DEF_EMPTYLABEL);

  WriteDiskBlocks(argv[1],block1_bytes,BLOCKOFFSET1,BLOCKCOUNT1);
  WriteDiskBlocks(argv[1],block2_bytes,BLOCKOFFSET2,BLOCKCOUNT2);

  exit(0);
}

void SetDiskLabel(char *label)
{
  int i, len;
  unsigned char *ptr;
  int label_position[][2] =
  {
    1, 0x0424,
    1, 0x3614,
    1, 0x367c,
    2, 0x0024
  };

  for(i=0;i<4;i++)
  {
    ptr = (label_position[i][0] == 1 ? block1_bytes : block2_bytes);
    ptr += label_position[i][1];

#ifdef DEBUG
    {
      char oldlabel[MAX_LABELLENGTH+1];

      len = *ptr;
      strncpy(oldlabel,ptr+1,MIN(len,MAX_LABELLENGTH));

      printf("%d. Stelle: Lnge = %d, Inhalt = '%s'\n",i+1,len,oldlabel);
    }
#endif

    len = *ptr++ = MIN(strlen(label),MAX_LABELLENGTH);
    strncpy(ptr,label,len);
  }
}

void WriteDiskBlocks(char *device,unsigned char *blocks, int offset, int count)
{
  int fd_device;

  if ((fd_device=open(device,O_WRONLY))<0)
  {
    perror(device);
    exit(-1);
  }
  lseek(fd_device, offset*BLOCKSIZE, SEEK_SET);
  if (write(fd_device, blocks, count*BLOCKSIZE)!=count*BLOCKSIZE)
  {
    perror(device);
    exit(-1);
  }
  close(fd_device);
}
