#include <errno.h>
#include <memory.h>
#include <stdio.h>
#include <fcntl.h>
#include <linux/fd.h>
extern long lseek();
extern char *optarg;

int fd;

char *drive_name[2] = {"/dev/fd0h1200","/dev/fd1h1200"};
char *alt_drive_name[2] = {"/dev/fd0H1440","/dev/fd1H1440"};
int drive_index=0;

#define SECTSIZE	512
#define TRACKS 	80
#define HEADS		2

char sector_count[2] = {15,18};
char *sector_count_name[2] = {"HD 1.2M","HD 1.44M"};
int sector_index=0;

#define SECTORMAX	18

unsigned char buf[TRACKS+1][HEADS*SECTORMAX*SECTSIZE];
unsigned char ans[80];

long seekres;
int format=0;
int verify=0;
int beeps=0;
int continue_on_error=0;
int i,t,h,s;
int dst_count = 10000;
int src_count = 1;
int sv,dv;

struct format_descr fmtbuf;

main(argc,argv)
int argc;
char **argv;
{
	while ((i=getopt(argc,argv,"SDcbvfd:s:")) != EOF) {
		switch (i) {
		case 'b':
			beeps = 1;
			break;
		case 'f':	
			format = 1;
			break;
		case 'v':
			verify = 1;
			break;
		case 'd':
			dst_count = atoi(optarg);
			break;
		case 's':
			src_count = atoi(optarg);
			break;
		case 'c':
			continue_on_error = 1;
			break;
		case 'S':
			drive_name[0] = alt_drive_name[0];
			drive_name[1] = alt_drive_name[1];
			sector_index = 1;
			break;
		case 'D':
			drive_index = 1;
			break;
		default:
			printf("syntax: fdup [-fvcbDS] [-s n] [-d n]\n");
			printf("   -f    format destination\n");
			printf("   -v    verify write\n");
			printf("   -c    continue on read error\n");
			printf("   -b    beep at diskette change\n");
			printf("   -D    use drive 1 (default: drive 0)\n");
			printf("   -S    drive is 1.44 meg (default: 1.2 meg)\n");
			printf("   -s n  number of source diskettes (default: 1)\n");
			printf("   -d n  number of destination diskette sets (default: 10000)\n");
			exit();
			break;
		}
	}
	setvbuf(stdout,NULL,_IONBF,0);
	setvbuf(stderr,NULL,_IONBF,0);
	printf("\nFloppy duplicator.  V2.0.  by Mark K Vallevand\n\n");
	printf("\nDest floppies will be ");
	if (format) {
		printf("formatted & ");
	}
	printf("written ");
	if (verify) {
		printf("& verified");
	} 
	printf(" as %s in drive %d\n",sector_count_name[sector_index],drive_index);
	for (sv=1; sv<=src_count; sv++) {
		if (beeps) {
			fprintf(stderr,"");
			usleep(200000L);
			fprintf(stderr,"");
			usleep(200000L);
			fprintf(stderr,"");
		}
		printf("\nSource #%d of %d: Insert %s floppy into drive %d and press <Enter>\n",
			sv,src_count,sector_count_name[sector_index],drive_index);
		gets(ans);
		fd = open(drive_name[drive_index],O_RDONLY);
		if (fd < 0) {
			printf("Cannot open %s for reading %d\n",drive_name[drive_index],errno);
			exit();
		}
		for (t=0; t<TRACKS; t++) {
			seekres = lseek(fd,(long)((long)t*(long)(HEADS*SECTSIZE*sector_count[sector_index])),0);
			if (seekres < 0) {
				printf("\nSeek error %ld %d\n",seekres,errno);
				exit();
			}
			printf("\rTrack %3d Reading",t);
			i = read(fd,&buf[t][0],HEADS*SECTSIZE*sector_count[sector_index]);
			printf("\rTrack %3d Read   ",t);
			if (i != HEADS*SECTSIZE*sector_count[sector_index]) {
				printf("\nRead error %d %d\n",i,errno);
				if (!continue_on_error) {
					exit();
				}
				else
				{
					for (s=0; s<sector_count[sector_index]*HEADS; s++)
					{
						seekres = lseek(fd,(long)((long)t*(long)(HEADS*SECTSIZE*sector_count[sector_index]))+(long)s*(long)(SECTSIZE),0);
						if (seekres < 0) {
							printf("\nSeek error %ld %d\n",seekres,errno);
							exit();
						}
						printf("\rTrack %3d Sector %d Reading",t,s);
						i = read(fd,&buf[t][s],SECTSIZE);
						printf("\rTrack %3d Sector %d Read   ",t,s);
						if (i != SECTSIZE) {
							printf("\nRead error %d %d\n",i,errno);
						}
					}
				}
			}
		}
		printf("\rFloppy read              \n");
		close(fd);
		for (dv=1; dv<=dst_count; dv++) {
			if (beeps) {
				fprintf(stderr,"");
				usleep(200000L);
				fprintf(stderr,"");
				usleep(200000L);
				fprintf(stderr,"");
			}
			printf("\nDest #%d of %d for src #%d: Insert %s floppy into drive %d & press <Enter>\n",
				dv,dst_count,sv,sector_count_name[sector_index],drive_index);
			gets(ans);
			fd = open(drive_name[drive_index],O_RDWR);
			if (fd < 0) {
				printf("Cannot open %s for writing %d\n",drive_name[drive_index],errno);
				exit();
			}
			fmtbuf.device = drive_index;
			for (t=0; t<TRACKS; t++) {
				if (format) {
					printf("\rTrack %3d Format head 0",t);
					fmtbuf.track = t;
					fmtbuf.head = 0;
					i = ioctl(fd,FDFMTTRK,&fmtbuf);
					if (i < 0) {
						printf("\nIoctl FDFMTTRK error %d %d\n",i,errno);
						t = TRACKS;
						continue;
					}
					printf("\rTrack %3d Format head 1",t);
					fmtbuf.head = 1;
					i = ioctl(fd,FDFMTTRK,&fmtbuf);
					if (i < 0) {
						printf("\nIoctl FDFMTTRK error %d %d\n",i,errno);
						t = TRACKS;
						continue;
					}
				}
				seekres = lseek(fd,(long)((long)t*(long)(HEADS*SECTSIZE*sector_count[sector_index])),0);
				if (seekres < 0) {
					printf("\nSeek error %ld %d\n",seekres,errno);
					t = TRACKS;
					continue;
				}
				printf("\rTrack %3d Writing      ",t);
				i = write(fd,&buf[t][0],HEADS*SECTSIZE*sector_count[sector_index]);
				if (i != HEADS*SECTSIZE*sector_count[sector_index]) {
					printf("\nWrite error %d %d\n",i,errno);
					t = TRACKS;
					continue;
				}
				fsync(fd);
				printf("\rTrack %3d Written      ",t);
			}
			if (verify) {
				sleep(2);
				i = ioctl(fd,FDFLUSH);
				if (i < 0) {
					printf("\nIoctl FDFLUSH error %d %d\n",i,errno);
					t = TRACKS;
					continue;
				}
				for (t=TRACKS-1; t>=0; t--) {
					seekres = lseek(fd,(long)((long)t*(long)(HEADS*SECTSIZE*sector_count[sector_index])),0);
					if (seekres < 0) {
						printf("\nSeek error %ld %d\n",seekres,errno);
						t = 0;
						continue;
					}
					printf("\rTrack %3d Reading ",t);
					i = read(fd,&buf[TRACKS][0],HEADS*SECTSIZE*sector_count[sector_index]);
					printf("\rTrack %3d Read    ",t);
					if (i != HEADS*SECTSIZE*sector_count[sector_index]) {
						printf("\nRead error %d %d\n",i,errno);
						t = 0;
						continue;
					}
					if (memcmp(&buf[TRACKS][0],&buf[t][0],HEADS*SECTSIZE*sector_count[sector_index]) == 0) {
						printf("\rTrack %3d Verified",t);
					} else {
						printf("Miscompare at track %d\n",t);
						t = 0;
						continue;
					}
				}
			}
			printf("\rFloppy ");
			if (format) {
				printf("formatted and ");
			}
			printf("written ");
			if (verify) {
				printf("and verified");
			} 
			printf("                   \n");
			close(fd);
		}
	}
}
