/*************************************************************************
 **									**
 ** doprog(8):	Execute a program (with arguments) on a new tty		**
 **		Based on doshell(8) by Jim Wiegand.			**
 **									**
 ** Copyright 1992 by Jim Wiegand					**
 ** Copyright 1993,1994 by James H. Cloos, Jr. <James.Cloos@Rahul.NET>	**
 **									**
 *************************************************************************/

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

void main( int argc, char **argv ) {
  
  int fd;
  struct stat *ssp;
  
/* Make sure the tty exists! */
  if ( stat(argv[1],ssp) ) {
    perror(argv[1]);
    exit(1);
  }

  if ( !S_ISCHR(ssp->st_mode) ) {
    fprintf(stderr,"%s is not a character special device.\n",argv[1]);
    exit(2);
  }
    
    if( !fork() ) {
      
      /* go underground */
      setsid();
      
      /* get rid of existing tty */
      close(0); close(1); close(2);
      
      /* get new one & make it standard */
      fd = open(argv[1], O_RDWR);
      dup(fd); dup(fd);
      
      /* kill supervisor mode */
      setgid(getgid());
      setuid(getuid());
      
      /* do it */
      execvp(argv[2], argv+2);
      
    }
  /* not reached */
}
