/***
 *** validate.h, mode validation functions
 *** (c) 1995 Koen Gadeyne (kmg@barco.be)
 ***/

#ifndef _VALIDATE_H
#define _VALIDATE_H

#include "configfile.h"
#include "modedata.h"
#include "parse_modeline.h"

#define MAX_CLOCKDEVIATION  3.0


int check_range(float checkval, float range[MAX_RANGE_SPECS][2]);

int validate_clock(int chipset, t_clockdef* ck, float req_clock, float* realclock, int optionmask, int report_error);;

void scan_valid_modes(FILE* configfile, int chipset, t_clockdef* ck,
                      float hsync_range[MAX_RANGE_SPECS][2],
                      float vsync_range[MAX_RANGE_SPECS][2],
                      int optmask, int validate);

void check_and_show_mode(int chipset, modestruct* p_mode, t_clockdef* ck,
                         float hsync_range[MAX_RANGE_SPECS][2],
                         float vsync_range[MAX_RANGE_SPECS][2],
                         int optmask, int checkit, const char* chipset_id);

#endif
