/***
 *** modedata: routines for text/graphics mode grabbing
 *** Copyright (c) 1995 by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _MODEDATA_H
#define _MODEDATA_H


/* defines for text/graphiecs mode */ 
#define MODE_UNDEFINED -1
#define MODE_TEXT      0
#define MODE_GRAPHICS  1

/* defines for special mode flags */
#define DOUBLESCAN     (1<<0)
#define CLOCKDIV2      (1<<1)
#define MULTISCAN      (1<<2)       /* MSL>2 in graphics mode */
#define BYTEMODE       (1<<3)
#define WORDMODE       (1<<4)
#define DOUBLEWORDMODE (1<<5)


typedef struct modestruct {
      char idstring[64];                                   /* identification string */
      int txt_gr_mode;                                     /* text or graphics mode: MODE_TEXT or MODE_GRAPHICS */
      int activepix, start_hsync, stop_hsync, totalh;      /* H parameters */
      int activelines, start_vsync, stop_vsync, totalv;    /* V parameters */
      int logical_width;                                    /* screen width according to offset register */
      int h_polarity, v_polarity;                          /* sync polarities: pos number for +sync, neg number for -sync */
      int starthbl, endhbl, startvbl, endvbl;              /* blanking parameters */
      int font_width, font_height;                         /* font parameters */
      int cols, rows;                                      /* screen geometry */
      float pclock;                                        /* pixel clock (in MHz) */
      float hor_freq;                                      /* horizontal frequency (in kHz) */
      float vert_refresh;                                  /* vertical refresh (in Hz) */
      int mode_flags;                                      /* special mode flags */
} modestruct;

void getmode(modestruct* m, int probe_clock);

#endif

