/***
 *** modedata: routines for text/graphics mode grabbing
 *** Copyright (c) 1995 by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifndef DOS
#include <unistd.h>
#include <asm/io.h>
#endif

#include "misc.h"
#include "vga_prg.h"
#include "confdefs.h"
#include "messages.h"
#include "probe.h"
#include "modedata.h"

#ifdef DOS
#define get_VGA_io_perm(x)
#undef Renounce_SUID
#define Renounce_SUID
extern int optind;
#endif

void getmode(modestruct* m, int probe_clock)
{

  get_VGA_io_perm(CS_VGA);
  unlock(CS_VGA); /* unlock standard VGA locked registers */

  m->activepix = Get_HOR_DISPL_END()*8;
  m->start_hsync = Get_HSYNC_START()*8;
  m->stop_hsync = Get_HSYNC_END()*8;
  m->totalh = Get_HOR_TOTAL()*8;
  m->activelines = Get_VERT_DISPL_END();
  m->start_vsync = Get_VRETRACE_START();
  m->stop_vsync = Get_VRETRACE_END();
  m->totalv = Get_VERT_TOTAL();
     
  m->font_width = get_charwidth();
  m->font_height = Get_MAX_SCANLINE();
     
  m->h_polarity = Get_HSYNC_POLARITY();
  m->v_polarity = Get_VSYNC_POLARITY();
     
  m->starthbl = Get_HBLANK_START()*8;
  m->endhbl = Get_HBLANK_END()*8;
  m->startvbl = Get_VBLANK_START();
  m->endvbl = Get_VBLANK_END();

  m->txt_gr_mode = Get_TX_GR_Mode();

  /* special flags */
  m->mode_flags = 0;
  if (Inb_CRTC(0x09) & 0x80) m->mode_flags |= DOUBLESCAN;
  /* MSL=2 is also used for doublescanning in graphics mode */
  if ((m->txt_gr_mode==MODE_GRAPHICS) && (m->font_height==2)) m->mode_flags |= DOUBLESCAN;
  if ((m->txt_gr_mode==MODE_GRAPHICS) && (m->font_height>2)) m->mode_flags |= MULTISCAN;
  if (Inb_SEQ(0x01) & 0x08) m->mode_flags |= CLOCKDIV2;  /* this has already been taken into account by clock probe */
  if (Inb_CRTC(0x17) & 0x40) m->mode_flags |= BYTEMODE; else m->mode_flags |= WORDMODE;
  if (Inb_CRTC(0x14) & 0x40) m->mode_flags |= DOUBLEWORDMODE;
  
  m->logical_width = Inb_CRTC(0x13)*8;
  if (m->mode_flags & DOUBLEWORDMODE) m->logical_width *=8;
  else if (m->mode_flags & WORDMODE) m->logical_width *=4;
  else m->logical_width *=2;
     
  /* see if vert resolution was multiplied by 2 (normally for modes with >1024 lines) */
  if ((Inb_CRTC(0x17) & 0x04) != 0)
  {
    m->activelines *= 2;
    m->start_vsync *= 2;
    m->stop_vsync *= 2;
    m->totalv *= 2;
  }
  
  /* TODO: detect CGA emulation */
  /* this does NOT use CRTC 0x17! , and NOT SEQ 1 */
  /* doubling pixels = ?   ATR 0x10 bit 6 ? */
  /* offset reg (CRTC 0x13) = ACTUAL screen width ?? */
     
  if (probe_clock)
  {
    m->pclock = pixclock((m->totalh/8)*m->font_width, m->totalv);
    m->hor_freq = (m->pclock/(m->totalh/8)/m->font_width)*1000;
    m->vert_refresh = (m->pclock/(m->totalh/8)/m->font_width/m->totalv)*1000000;
  }

  /* take double scanning into account. Must be done AFTER clock probe, because it must not be influenced by this */
  if (m->mode_flags & DOUBLESCAN)
  {
    m->activelines /= 2;
    m->start_vsync /= 2;
    m->stop_vsync /= 2;
    m->totalv /= 2;
  }

 /* if (ATR_CTL(0x10) & 0x40) : 1/2 H clock (256-color mode). Doet NIETS bij packed pixel modes */
  
#if 0
  /* this is VERY uncertain. Hopefully it helps to detect those "bogus" 320-pixel wide modes that show up as 640 */
  /* this breaks some "packed pixel" modes */
  if ((Inb_GR_CTL(0x05) & 0x40)  && (inb_ATR_CTL(0x10) & 0x40))
  {
    m->activepix /= 2;
    m->start_hsync /= 2;
    m->stop_hsync /= 2;
    m->totalh /= 2;
  }
#endif     
  
}
