/***
 *** message printing tools
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _MESSAGES_H
#define _MESSAGES_H

void print_msg(char *format,...);

extern char* CommandName;
extern int debug_messages;

#define MSGTYP_ERR   3
#define MSGTYP_WARN  2
#define MSGTYP_MSG   1
#define MSGTYP_DBG   0

extern int msgtype;

/* the "do { ... } while (0)" construct allows us to use these macro's as if they were functions.
 * Otherwise you cannot ALWAYS place a ';' at the end of a message printing macro.
 * suggested by Ton Hospel <Ton.Hospel@linux.cc.kuleuven.ac.be>
 */  

#define PDEBUG(arg)  do { msgtype=MSGTYP_DBG ; print_msg arg; } while (0)

#define PERROR(arg)  do { msgtype=MSGTYP_ERR ; print_msg arg; exit (1); } while (0)

#define PWARNING(arg)  do { msgtype=MSGTYP_WARN ; print_msg arg; } while (0)

#define PMESSAGE(arg) do { msgtype=MSGTYP_MSG ; print_msg arg; } while (0)

#endif

