.\" Copyright (c) 1994 Loganville Technical Resources, Inc
.\"
.TH XZET 1 "Xzet 1.0,  Loganville Technical Resources, Inc" "02/94"
.UC 5
.SH NAME
xzet \- Graphical System Activity Monitor
.SH SYNOPSIS
xzet
.SH DESCRIPTION
.B xzet
is an 
.B X
windows application which is 
.B Zmans'
version of 
.B xEtat
and 
.B Top
, hence
the name
.B XZET.
It provides 3 different types of real time system resource monitoring
windows.  When it is first started, the user is presented with its main 
menu and an 
.B About Xzet
window,  which gives a brief description of xzet and shows the 
\f2known\f1 copyright holders of xzet and its constituent parts.
.LP
.LP
Selecting 
.B Activity
from the main menu will bring up the first of the three monitor windows, the 
.B System Activity Window
,  which displays stripcharts of the
.B CPU
\f2idle\f1, \f2user\f1, \f2system\f1 and \f2nice\f1 times, expressed as a percentage.  
This window also has 
.B memory
stripcharts for \f2free swap space\f1 and \f2free physical memory\f1.  Across
the top of the window is a count and overview of all of the currently running  
.B processes.
This is broken down into the number of sleeping, running, zombie and stopped
process.  On the right hand side of this window there are 
.B freespace monitors
for up to three user selected file systems.  Both the total bytes available
in the file system and the total bytes available to the super-user are
given.  Under these monitors, the size of available 
.B User Physical Memory
and of the 
.B System Swap space
is also listed.
.LP
.LP
Selecting 
.B Processes
from the main menu brings up the next window available from 
.B xzet 
,the global 
.B Process Status List.
This window has \f2three formats\f1 and \f2two modes\f1, which can be 
selected by the user via buttons located at the bottom of the window.  
The user can choose between a single or double column short format 
listing and single column long format. The long format includes the
following fields, in the order specified:
.TP 6
.B Process Id
Self explanatory.
.TP 6
.B Parent Process Id
Self explantory.
.TP 6
.B Status
The current status of the process.  This will be 'R' for running, 'S' for
sleeping, 'D' for uninterruptible sleep, 'T' for stopped or traced, and 'Z'
for zombie. Non-zombie processes with a resident size (see below) of zero 
will have a 'W' appended. Processes with a priority greater than "standard"
( 15 for
.B xzet
) will have a '<' appended, while processes with a priority less
than "standard" will have an 'N' appended.
.TP 6
.B Priority
The priority of the process.  A 'P' is appended to all entries in this field for
clarity. 
.TP 6
.B Nice Priority
The Nice value of the process.  Negative values represent lower priorities.
An 'N' is appended to all entries in this field for clarity.
.TP 6
.B Memory
The number of \f2kilobytes\f1 used by the processes \f2code\f1 + \f2data\f1 + 
\f2stack\f1. An 'M' is appended to all entries in this field for clarity.
.TP 6
.B Physical Memory
The number of \f2kilobytes\f1 of physical memory used by the process. (The
"Resident" size)  An 'R' is appended to all entries in this field for
clarity.
.TP 10
\f2Notes regarding Memory & Physical Memory:\f1
These two fields do not include the page tables and task_struct of the
process.  For Linux, this is at least 12k of 
.B resident 
memory.
.TP 6 
.B Shared Memory
The number of \f2kilobytes\f1 of shared memory used by the process.  An 'S' 
is appended to all entries in this field for clarity.
.TP 6
.B CPU Time
The processes total cpu time ( \f2utime\f1 + \f2stime\f1 ) since it began
execution.
.TP 6
.B Percent Memory
The processes share of the \f2available physical memory\f1, expressed as a
percentage.  Note that the available memory will be less then the amount of
memory installed in your machine.  The resident size of the process is used
in this calculation. Entries in this field have 'M%' appended to them.
.TP 6
.B Percent CPU
The processes share of CPU time since the last update interval, expressed as
a percentage.  Entries in this field have 'C%' appended to them.
.TP 6
.B Control Device
The "user I/O device" associated with the process.  Not necessarily a
physical terminal.  Typical identifiers examples are: 'v06' for virtual
console 6; 'pp0' for pseudo-tty 0; and '?' for processes auto-started at
system start-up (and therefore not associated with any control device).
.TP 6
.B User Name
Self explanatory.
.TP 6
.B Command Line
The command line used to start the process is shown here.  If no command
line was used or if the process has been swapped out to disk, it is typical 
to see the name of the process, without command line arguments,  in 
parenthesis (eg "(init)").  This field is truncated to 20 characters if 
necessary.
.LP
If the 
.B short format 
is selected only the \f2 Process ID, Parent Process ID,
Status, CPU Time, Percent Memory, Percent CPU, User Name,\f1 and 
\f2Command Line\f1 Fields will be displayed.   
.LP
The user can select between an 
.B Auto Update
and
.B Freeze
mode for the process list using the command button immediately to the right
of the 'quit' button at the bottom of the window.  This is a \f2toggle\f1
button whose label will change between 'Auto Update' and 'Freeze' to
indicate which action will occur the next time the button is pressed. In
auto update mode, the process list will be updated approximately every three
seconds.
.LP
.LP
The final window offered by 
.B xzet
is the 
.B Individual Process Pop-up Window
, available by selecting
(\f2left-clicking\f1) a process entry from the global process list.  The
title of this window is of the form \f2host-name\f1:\f2process id\f1 -
\f2command line\f1.  The following \f2labeled\f1 fields are presented in 
the main body of the window:
.TP 6
.B
PPID
The parent process id of the process.
.TP 6
.B TTY
See the above description for the
.B Control Device
field
.TP 6
.B STIME
The total amount of \f2system\f1 time accumulated by the process since it
first began execution.
.TP 6
.B UTIME
The total amount of \f2user\f1 time accumulated by the process since it
first began execution. 
.TP 6
.B USER
The name of the user that started the process.
.LP
On the right hand side of this window are two fields, one with the prefix
.B T:
and the other with the prefix
.B F:.
These enumerate the \f2size\f1 (see the above description for the
.B Memory
field) of the process, and the total system-wide \f2free physical memory\f1, 
both expressed in \f2bytes\f1.
.LP
The main feature of this window is two \f2Ztach widgets\f1, one of which is
labeled 
.B % CPU
and the other
.B % MEM.
These are graphical representations of the data in the  
.B Percent CPU
and
.B Percent Memory
fields described above.  Two relevant notes apply. First the numeric fields 
under the indicator arms are scaled to 10 times the percentage value (eg
23.4 percent is expressed as 234).  Second, the memory gauges indicator arm
rotates in the opposite direction of the cpu gauges indicator arm, hence the
zero point is on the right side of the gauge.  This is configurable in the
applcation defaults file for 
.B xzet.
.LP
If a process terminates while a pop-up window is active for it, the pop-up
will be automatically closed and removed from the display.
.LP
.SH NOTES
The \f2application defaults\f2 file for 
.B xzet
should be changed, at the very least, to include the mount points of the
file systems to be monitored.  
.LP
See the 
.B README
file for notes  on the developement, undocumented features (bugs),
future, building and other information about xzet.           
.SH COPYRIGHT
.B Xzet
is Copyright (C) 1994  Loganville Technical Resources, Incorporated. (See
.B Authors
below for other related copyrights.)  Xzet is free software; you can
redistribute it and/or modify it under the terms of the GNU General Public 
License as published by the Free Software Foundation; either version 2, 
or (at your option) any later version.  Xzet is distributed in the hope 
that it will be useful, but 
.B WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
.B or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.
.LP
You should have received a copy of the GNU General Public License along with 
xzet; see the file 
.B COPYING. 
If  not, write to the Free Software Foundation, 675 Mass Ave, Cambridge, 
MA 02139, USA.
.SH AUTHOR
Zman, Loganville Technical Resources, Incorporated.  5145 Ozora Church Road,
Loganville Georgia  30249, USA.
.LP
The author of 
.B Xetat
is Pierre FICHEUX,  Lectra-Systemes R&D. ZI Marticot 33610 Cestas FRANCE.
.LP
The authors of
.B Top
are
.LP
.nf 
Branko Lankester (Copyright (c) 1992) 
Roger Binns (Copyright (c) 1992)
Michael K. Johnson, johnsonm@stolaf.edu. 
Robert J. Nation (nation@rocket.sanders.lockheed.com).   
.fi
.LP
\f2Only Zman\f1 was involved in the development of 
.B xzet
, so the other people should not be contacted regarding bugs in it.

