/*
 * Copyright (C)1995 by Alexander Tietzel
 */
 
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/major.h>
#include <linux/sched.h>
#include <linux/lp.h>
#include <linux/malloc.h>
#include <linux/ioport.h>
#include <linux/fcntl.h>

#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>

#include <linux/led.h>

/* #define LED_PORT 0x280 */
#define MAX_PORTNO 1 
#define NUMBER_OF_LIGHTS 10
#define LED_2_PRT_MASK 0x03

unsigned led_mode_flags;
unsigned char led_port_buffer[MAX_PORTNO];

void led_bitset(int bitfield)
  {
  outb_p(~(char)bitfield, LED_PORT);
  led_port_buffer[1] &= ~LED_2_PRT_MASK;
  led_port_buffer[1] |= (~(char)(bitfield>>8)) & LED_2_PRT_MASK;
  outb_p(led_port_buffer[1], LED_PORT+1);
  }

void led_bargraph(char number)
  {
  int bitfield = 0;

  if (number > NUMBER_OF_LIGHTS) number = NUMBER_OF_LIGHTS;
  for ( ; number > 0; number--)
    {
    bitfield <<=1;
    bitfield |= 1;
    }

  led_bitset(bitfield);
  }

static int led_write(struct inode * inode, struct file * file, char * buf, int count)
  {
  int bitfield = 0;
  char * bufptr = buf;
  unsigned int minor = MINOR(inode->i_rdev);
  if (minor <= MAX_PORTNO) {
    if (minor == 0) {
      switch (led_mode_flags && 0x02) {
        case LED_BARGRAPH: 
          led_bargraph(get_fs_byte(bufptr+count-1));
          break;
        case LED_BITSET: {
          while (count >0)
            {
            bitfield |= (1 << get_fs_byte(bufptr));
            count--;
            bufptr++;
            }
          led_bitset(bitfield);
          }
          break;
        }
      return 1;
      }
    else if (minor == 1) {
      led_port_buffer[1] &= LED_2_PRT_MASK;
      led_port_buffer[1] |= (~get_fs_byte(bufptr+count-1)) << 2;
      outb_p(led_port_buffer[1], LED_PORT+1);
      return 1;
      }
    if (minor >= 2) {
      led_port_buffer[minor] = (get_fs_byte(bufptr+count-1));
      outb_p(led_port_buffer[minor], LED_PORT+minor);  
      return 1;
      }
    }
  printk(KERN_NOTICE "led: no port at 0x%x\n", LED_PORT+minor);
  return 0;
  }

static int led_ioctl(struct inode *inode, struct file *file,
			unsigned int cmd, unsigned long arg)
  {
  /* unsigned int minor = MINOR(inode->i_rdev); */

  switch (cmd) {
    case LED_CMD_MODE: {
      led_mode_flags &= 0xFC;
      led_mode_flags |= (arg && 0x02);
      }
    break;
    }
  return 1;
  }

static struct file_operations led_fops = {
	NULL,           /* led_lseek */
	NULL,		/* led_read */
	led_write,
	NULL,		/* led_readdir */
	NULL,		/* led_select */
	led_ioctl,
	NULL,		/* led_mmap */
	NULL,           /* led_open */
	NULL            /* led_release */
}; 

long led_init(long kmem_start)
  {
  int count =0;
  led_mode_flags = 0;
	
  if (register_chrdev(LED_MAJOR,"led",&led_fops)) {
    printk("unable to get major %d for led-port-card\n", LED_MAJOR);
    return kmem_start;
    }
  else
    printk("LED-Port driver Port 0x%x\n", LED_PORT);
  for (; count <= MAX_PORTNO; count++)
    {
    outb_p( 0xFF, LED_PORT+count);
    led_port_buffer[count] = 0xFF;
    }
  return kmem_start;
  }
