/*
 * gather.c		- gather and report process info.
 *
 * Michael Hamilton (michael@actrix.gen.nz).
 * Copyright (c) 1995
 *
 * Snarfed and HEAVILY modified from top in process ps
 * by Branko Lankester and Roger Binns.
 *
 */


#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <sys/ioctl.h>
#include <pwd.h>
#include <linux/sched.h>
#include <linux/tty.h>
#include <termcap.h>
#include <termios.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <ctype.h>
#include <setjmp.h>

#include "sysinfo.h"
#include "ps.h"
#include "whattime.h"
#include "signals.h"


void show_process(struct ps_proc *info)
{

  struct {
    int pid ;
    float cpu_utilisation ;
    float memory_utilisation ;
    float resident ;
    float total_time ;
  } process_info ;

  double up ;
  double idle ;

  unsigned long cpu_time ;

  unsigned mem_total, mem_used, mem_free, mem_shared, mem_buffers ;

  if (!info) {
    return ;
  }

  meminfo(&mem_total, &mem_used, &mem_free, &mem_shared, &mem_buffers) ;

  cpu_time = (info->utime + info->stime) / HZ ;

  uptime(&up, &idle) ;
  process_info.total_time = (((up * 100.0) - info->start_time) / HZ) / (60.0 * 60.0);  

  process_info.cpu_utilisation = 5.0 * (float) cpu_time / 60.0 ;

  /*  printf ("mem %d %d\n", info->vsize, mem_total); */

  process_info.memory_utilisation = (float) info->vsize / 1048576.0 ;

  process_info.resident = (float) info->rss / 1024 ;

  printf("% 5d\n%s\n %f %f %f %f\n",
	 info->pid,
	 info->user,
	 process_info.cpu_utilisation,
	 process_info.resident,
	 process_info.memory_utilisation,
	 process_info.total_time
	 ) ;
  
}


void show_all_processes ()
{
  float location ;
  time_t now;

  char host[80] ;

  struct ps_proc_head *ph = NULL;
  struct ps_proc *this ;

  if (!ph) {
    ph = take_snapshot(1, 1, 1, 0, 0, 0, 0) ;
  }
  else {
    ph = refresh_snapshot(ph, 1, 1, 1, 0, 0, 0, 0) ;    
  }

  if (!ph->count) {
    fprintf(stderr, "No processes available\n");
    exit(1);
  }
  gethostname(host, 79);
  now = time(NULL);
  printf("Process View: %s %s", host, ctime(&now));
  printf("%d %d CPU RSS Mem Time\n", ph->count, 4) ;

  for (this = ph->head, location = -(ph->count / 2) ;  this != NULL ; this = this->next, ++location) {
    show_process(this) ;
  }

}

void usage(void) 
{
  printf("Usage: gather [-sleep n]\n");
}

int
main(int argc, char **argv)
{
  /* loop, collecting process info and sleeping */
  
  int i, seconds = 2;  

  for (i = 1; i < argc; ++i) {

    if (!strcmp("-sleep", argv[i])) {
      seconds = strtol(argv[++i],NULL,0);

    } else {
      usage();
    }
  }

  setvbuf(stdout,NULL,_IONBF,0);
  for (;;) {
    show_all_processes() ;
    sleep(seconds) ;
  }
}



